//-----------------------------------------------------------
// UT2DMutator_Instagib
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DMutator_Instagib extends UTMutator;

function InitMutator(string Options, out string ErrorMessage)
{
	if(UTGame(WorldInfo.Game) != none)
	{
		UTGame(WorldInfo.Game).DefaultInventory.Length = 0;
		UTGame(WorldInfo.Game).DefaultInventory[0] = class'UT2DMutator_Instagib.UT2DWeap_InstagibRifle';
		if(UTTeamGame(WorldInfo.Game) != none)
			UTTeamGame(WorldInfo.Game).TeammateBoost = 0.6;
	}

	super.InitMutator(Options, ErrorMessage);
}

function bool CheckReplacement(Actor Other)
{
	if(Other.IsA('UTWeapon') && !Other.IsA('UTVehicleWeapon') && !Other.IsA('UT2DWeap_InstagibRifle') && !Other.IsA('UTWeap_Translocator'))
		return false;
	else
		return !Other.IsA('PickupFactory');
}

defaultproperties
{
	GroupNames[0]="WEAPONMOD"
	GroupNames[1]="WEAPONRESPAWN"
	GroupNames[2]="HANDICAP"
	GroupNames[3]="POWERUPS"
}