//-----------------------------------------------------------
// UT2DWeap_RocketLauncher
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DWeap_RocketLauncher extends UTWeap_RocketLauncher;

//DropFrom
function DropFrom(vector StartLocation, vector StartVelocity)
{
	local float Magnitude;
	
	StartLocation.Y = 0;
	
	Magnitude = vsize(StartVelocity);
	StartVelocity.Y = 0;
	StartVelocity = normal(StartVelocity) * Magnitude;
	
	super.DropFrom(StartLocation, StartVelocity);
}

//SimpleCrosshair Fix
simulated function ActiveRenderOverlays(HUD H)
{
	local UTPlayerController PC;

	PC = UTPlayerController(Instigator.Controller);
	if(PC == none)
		return;

	if(PC.bNoCrosshair)
		return;

	if (PC.bSimpleCrosshair)
	{
		CrossHairCoordinates = SimpleCrosshairCoordinates;
		global.DrawWeaponCrosshair(H);
	}
	else
	{
		CrossHairCoordinates = default.CrosshairCoordinates;
		DrawWeaponCrosshair(H);
	}

	if(bLockedOnTarget && (LockedTarget != none) && (Instigator != none))
	{
		if((LocalPlayer(PC.Player) == none) || !LocalPlayer(PC.Player).GetActorVisibility(LockedTarget))
			return;
		DrawLockedOn(H);
	}
	else
		bWasLocked = false;

}

//DrawWeaponCrosshair
simulated function DrawWeaponCrosshair(Hud HUD)
{
	local vector2d CrosshairSize;
	local float X, Y, PickupScale, ScreenX, ScreenY;
	local UTHUD	H;
	local UTPlayerController PC;
	local vector ViewLocation;
	
	H = UTHUD(HUD);
	if(H == none)
		return;
	
	PC = UTPlayerController(Instigator.Controller);
	if(PC == none)
		return;
		
	if(H.LastPickupTime > WorldInfo.TimeSeconds - 0.3)
	{
		if(H.LastPickupTime > WorldInfo.TimeSeconds - 0.15)
			PickupScale = (1 + 5 * (WorldInfo.TimeSeconds - H.LastPickupTime));
		else
			PickupScale = (1 + 5 * (H.LastPickupTime + 0.3 - WorldInfo.TimeSeconds));
	}
	else
		PickupScale = 1.0;

 	CrosshairSize.Y = CrosshairScaling * CrossHairCoordinates.VL * PickupScale * H.Canvas.ClipY / 768;
  	CrosshairSize.X = CrosshairSize.Y * (CrossHairCoordinates.UL / CrossHairCoordinates.VL);
	
	if(UT2DController_Player(PC) != none)
	{
		ViewLocation = H.Canvas.Project(UT2DController_Player(PC).LastViewLoc);
		X = ViewLocation.X + UT2DController_Player(PC).Look.X * H.Canvas.ClipY * 0.2;
		Y = ViewLocation.Y - UT2DController_Player(PC).Look.Z * H.Canvas.ClipY * 0.2;
	}
	else if(UT2DController_ConsolePlayer(PC) != none)
	{
		ViewLocation = H.Canvas.Project(UT2DController_ConsolePlayer(PC).LastViewLoc);
		X = ViewLocation.X + UT2DController_ConsolePlayer(PC).Look.X * H.Canvas.ClipY * 0.2;
		Y = ViewLocation.Y - UT2DController_ConsolePlayer(PC).Look.Z * H.Canvas.ClipY * 0.2;
	}
	
	ScreenX = X - (CrosshairSize.X * 0.5);
	ScreenY = Y - (CrosshairSize.Y * 0.5);
	
	if(CrosshairImage != none)
	{
		H.Canvas.DrawColor = H.BlackColor;
		H.Canvas.SetPos(ScreenX + 1, ScreenY + 1);
		H.Canvas.DrawTile(CrosshairImage, CrosshairSize.X, CrosshairSize.Y, CrossHairCoordinates.U, CrossHairCoordinates.V, CrossHairCoordinates.UL, CrossHairCoordinates.VL);
		
		CrosshairColor = H.bGreenCrosshair ? H.Default.LightGreenColor : Default.CrosshairColor;
		H.Canvas.DrawColor = (WorldInfo.TimeSeconds - LastHitEnemyTime < 0.3) ? H.RedColor : CrosshairColor;
		H.Canvas.SetPos(ScreenX, ScreenY);
		H.Canvas.DrawTile(CrosshairImage, CrosshairSize.X, CrosshairSize.Y, CrossHairCoordinates.U, CrossHairCoordinates.V, CrossHairCoordinates.UL, CrossHairCoordinates.VL);
	}
}

simulated function DrawLFMData(HUD Hud)
{
	local string S;
	local vector2d CrosshairSize;
	local float XL, YL, X, Y, PickupScale, ScreenX, ScreenY;
	local UTHUD	H;
	local int DrawLoaded;
	local rotator CrosshairRotation;
	local float TimeRemaining;
	local UTPlayerController PC;
	local vector ViewLocation;

	H = UTHUD(HUD);
	if(H == none)
		return;

	PC = UTPlayerController(Instigator.Controller);
	if(PC == none)
		return;
		
	if(H.LastPickupTime > WorldInfo.TimeSeconds - 0.3)
	{
		if(H.LastPickupTime > WorldInfo.TimeSeconds - 0.15)
			PickupScale = (1 + 5 * (WorldInfo.TimeSeconds - H.LastPickupTime));
		else
			PickupScale = (1 + 5 * (H.LastPickupTime + 0.3 - WorldInfo.TimeSeconds));
	}
	else
		PickupScale = 1.0;

	DrawLoaded = min(LoadedShotCount-1, 3);
 	CrosshairSize.Y = CrosshairScaling * LoadedIconCoords[DrawLoaded].VL * PickupScale * H.Canvas.ClipY / 768;
  	CrosshairSize.X = CrosshairSize.Y * LoadedIconCoords[DrawLoaded].UL / LoadedIconCoords[DrawLoaded].VL;
	
	if(UT2DController_Player(PC) != none)
	{
		ViewLocation = H.Canvas.Project(UT2DController_Player(PC).LastViewLoc);
		X = ViewLocation.X + UT2DController_Player(PC).Look.X * H.Canvas.ClipY * 0.2;
		Y = ViewLocation.Y - UT2DController_Player(PC).Look.Z * H.Canvas.ClipY * 0.2;
	}
	else if(UT2DController_ConsolePlayer(PC) != none)
	{
		ViewLocation = H.Canvas.Project(UT2DController_ConsolePlayer(PC).LastViewLoc);
		X = ViewLocation.X + UT2DController_ConsolePlayer(PC).Look.X * H.Canvas.ClipY * 0.2;
		Y = ViewLocation.Y - UT2DController_ConsolePlayer(PC).Look.Z * H.Canvas.ClipY * 0.2;
	}
	
	ScreenX = X - (CrosshairSize.X * 0.5);
	ScreenY = Y - (CrosshairSize.Y * 0.5);

	TimeRemaining = GetTimerCount('RefireCheckTimer');
	if(LoadedShotCount < 3)
		CrosshairRotation.Yaw = 21845.3333 * (LoadedShotCount - 1.0 + fmin(1.0, 2.0 * TimeRemaining / GetFireInterval(1)));
	
	H.Canvas.DrawColor = H.BlackColor;
	H.Canvas.SetPos(ScreenX, ScreenY);
	H.Canvas.DrawRotatedTile(CrosshairImage, CrosshairRotation, CrosshairSize.X, CrosshairSize.Y, LoadedIconCoords[DrawLoaded].U, LoadedIconCoords[DrawLoaded].V, LoadedIconCoords[DrawLoaded].UL,LoadedIconCoords[DrawLoaded].VL);

	H.Canvas.DrawColor = UTHUD(HUD).bGreenCrosshair ? UTHUD(HUD).Default.LightGreenColor : Default.CrosshairColor;
	H.Canvas.SetPos(ScreenX, ScreenY);
	H.Canvas.DrawRotatedTile(CrosshairImage, CrosshairRotation, CrosshairSize.X, CrosshairSize.Y, LoadedIconCoords[DrawLoaded].U, LoadedIconCoords[DrawLoaded].V, LoadedIconCoords[DrawLoaded].UL,LoadedIconCoords[DrawLoaded].VL);

	if(LoadedFireMode != RFM_Spread)
	{
		S = (LoadedFireMode == RFM_Spiral) ? SpiralString : GrenadeString;

		H.Canvas.Font = class'UTHUD'.static.GetFontSizeIndex(0);
		H.Canvas.StrLen(S, XL, YL);
		H.Canvas.SetPos(X - 0.5 * XL, Y + 0.71 * CrosshairSize.Y);
		H.Canvas.DrawText(s);
	}
}

//DefaultProperties
defaultproperties
{
	DroppedPickupClass=class'UT2DDroppedPickup'
	
	GrenadeClass=class'UT2DProj_Grenade'
}