//-----------------------------------------------------------
// UT2DProj_TransDiscBlue
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DProj_TransDiscBlue extends UTProj_TransDisc_ContentBlue;

//Tick
simulated function Tick(float DeltaTime)
{
	local vector loc;
	
	super.Tick(DeltaTime);
	
	//Clamp to Y = 0.
	loc = Location;
	loc.Y = 0;
	SetLocation(loc);
}

//Bounce into 2D
simulated event HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
	if(HitNormal.X != 0)
	{
		HitNormal.Y = 0;
		HitNormal = normal(HitNormal);
	}
	
	super.HitWall(HitNormal, Wall, WallComp);
}

//DefaultProperties
defaultproperties
{
}