//-----------------------------------------------------------
// UT2DHUD_CTF
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DHUD_CTF extends UTCTFHUD;

function DisplayDirectionIndicator(byte TeamIndex, vector2D POS, Actor DestActor, float DestScale)
{
	local rotator Dir, Angle;
	local vector Start;

	if(DestActor != none)
	{
		Start = (PawnOwner != none) ? PawnOwner.Location : UTPlayerOwner.Location;
		Dir  = Rotator(DestActor.Location - Start);
			
		Angle.Yaw = 16384 - Dir.Pitch;
		if(abs(Dir.Yaw) > 16384)
			Angle.Yaw = -Angle.Yaw;

		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(POS.X - (28.5 * DestScale * ResolutionScaleX), POS.Y - (26 * DestScale * ResolutionScale));
		Canvas.DrawRotatedTile(AltHudTexture, Angle, 57 * DestScale * ResolutionScaleX, 52 * DestScale * ResolutionScale, 897, 452, 43, 43);
	}
}