//-----------------------------------------------------------
// UT2DGame_Deathmatch
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DGame_Deathmatch extends UTDeathmatch;

static function bool AllowMutator(string MutatorClassName)
{
	if(MutatorClassName == "UTGame.UTMutator_Instagib")
		return false;
	
	return Super.AllowMutator(MutatorClassName);
}

//DefaultProperties
defaultproperties
{	
	//Naming
	MapPrefixes(0)="UT2D"

	//Game
	DefaultPawnClass=Class'UT2D.UT2DPawn'
	PlayerControllerClass=Class'UT2D.UT2DController_Player'
	ConsolePlayerControllerClass=class'UT2D.UT2DController_ConsolePlayer'
	BotClass=class'UT2D.UT2DBot'

	//Inventory
	DefaultInventory(0)=class'UT2DWeap_Enforcer'
	DefaultInventory(1)=class'UT2DWeap_ImpactHammer'
}