//-----------------------------------------------------------
// UT2DCheatManager
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DCheatManager extends UTCheatManager;

//AllWeapons
exec function AllWeapons()
{
	local bool bTranslocatorBanned;
	local UTVehicleFactory VF;
	
	if((WorldInfo.NetMode != NM_Standalone) || (Pawn == none))
		return;
	
	GiveWeapon("UT2D.UT2DWeap_Avril");
	GiveWeapon("UT2D.UT2DWeap_BioRifle");
	GiveWeapon("UT2D.UT2DWeap_FlakCannon");
	GiveWeapon("UT2D.UT2DWeap_LinkGun");
	GiveWeapon("UT2D.UT2DWeap_RocketLauncher");
	GiveWeapon("UT2D.UT2DWeap_ShockRifle");
	GiveWeapon("UT2D.UT2DWeap_Stinger");
	
	bTranslocatorBanned = false;
	ForEach WorldInfo.AllNavigationPoints(class'UTVehicleFactory', VF)
		bTranslocatorBanned = true;
	
	if(!bTranslocatorBanned)
		GiveWeapon("UT2D.UT2DWeap_Translocator");
}

//DoubleUp
exec function DoubleUp()
{
	local UT2DWeap_Enforcer MyEnforcer;
	
	MyEnforcer = UT2DWeap_Enforcer(Pawn.FindInventoryType(class'UT2DWeap_Enforcer'));
	MyEnforcer.DenyPickupQuery(class'UT2DWeap_Enforcer', none);
}

//PhysicsGun
exec function PhysicsGun();