//-----------------------------------------------------------
// UT2DBot
//
// Copyright 2008 Joe Bates
//
// This file is part of UT2D.
//
// UT2D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// UT2D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with UT2D.  If not, see <http://www.gnu.org/licenses/>.
//
// Last Modified: October 28, 2008
//-----------------------------------------------------------
class UT2DBot extends UTBot;

//Should never strafe
function bool ShouldStrafeTo(Actor WayPoint)
{
	return false;
}

//Adjust towards, not around
function bool AdjustAround(Pawn Other)
{
	AdjustLoc = Other.Location;
	return true;
}

//No need to clear paths when players don't collide
function ClearPathFor(Controller C)
{
}

//GetAdjustedAimFor
function rotator GetAdjustedAimFor(Weapon W, vector StartFireLoc)
{
	return Rotation;
}

//Make AI more aggressive
function bool FireWeaponAt(Actor A)
{
	Focus = A;
	return super.FireWeaponAt(A);
}
state Fallback
{
	function bool FireWeaponAt(Actor A)
	{
		Focus = A;
		return super.FireWeaponAt(A);
	}
}

//DefaultProperties
defaultproperties
{
}
