class BunnyTrailsGame extends UTCTFGame config(Game);

simulated function ScoreGoal(Controller Scorer) {
	local UTPlayerReplicationInfo ScorerPRI;
	local BTPlayerController PC;
	local UTGameReplicationInfo UTGRI;

	UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
	PC = BTPlayerController(Scorer);
	ScorerPRI = UTPlayerReplicationInfo(Scorer.PlayerReplicationInfo);

	if(PC != None) {
		PC.ClientMessage("!!! YOU SCORED A GOAL IN TIME = "
		$ class'UTHUD'.static.FormatTime(UTGRI.ElapsedTime -
						PC.TimerOffset));
		PC.TimerValue = 0;
		PC.TimerOffset = UTGRI.ElapsedTime;
		PC.SetServerTimerOffset(PC.TimerOffset);
	}

	ScorerPRI.Score += 15;
	ScorerPRI.bForceNetUpdate = true;
	ScorerPRI.Team.Score += 1.0;
	ScorerPRI.Team.bForceNetUpdate = true;

	CheckScore(ScorerPRI);
	Super(UTTeamGame).AnnounceScore(ScorerPRI.Team.TeamIndex);
	BroadcastLocalizedMessage(AnnouncerMessageClass,
		1+7*ScorerPRI.Team.TeamIndex, ScorerPRI, None, ScorerPRI.Team);

	if(bOverTime) {
		EndGame(ScorerPRI, "timelimit");
	}
}

function PreBeginPlay() {
	bWarmupRound = false;
	bPlayersVsBots = false;
	DesiredPlayerCount = 1;
	GoalScore = 3;
	MinNetPlayers = 0;
	bWaitForNetPlayers = true;

	Super.PreBeginPlay();
	UTTeamGame(WorldInfo.Game).FriendlyFireScale=0.0;
}

function PostBeginPlay() {
	Super(UTTeamGame).PostBeginPlay();
}

function PlayerStart ChoosePlayerStart(Controller Player,
						optional byte InTeam) {
	local PlayerStart PlSt;
	local BTPawn BP;

	PlSt = Super.ChoosePlayerStart(Player, InTeam);
	if(BTPRI(Player.PlayerReplicationInfo) != None) {
		BTPRI(Player.PlayerReplicationInfo).LastSpawnTime =
			UTGameReplicationInfo(WorldInfo.GRI).ElapsedTime;
	}
	return PlSt;
}

/*
function PostBeginPlay() {
	Super(UTTeamGame).PostBeginPlay();	
}
*/

function ScoreFlag(Controller Scorer, UTCTFFlag theFlag) {
	local float Dist,oppDist;
	local int i, GoalsScored;
	local float ppp,numtouch;
	local vector FlagLoc;
	local UTPlayerReplicationInfo ScorerPRI;
	local BTPlayerController PC;
	local UTGameReplicationInfo UTGRI;

	UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
	ScorerPRI = UTPlayerReplicationInfo(Scorer.PlayerReplicationInfo);
	if ( ScorerPRI.Team == theFlag.Team )
	{
		FlagLoc = TheFlag.Position().Location;
		Dist = vsize(FlagLoc - TheFlag.HomeBase.Location);
		oppDist = vsize(FlagLoc - Teams[1-TheFlag.Team.TeamIndex].HomeBase.Location);

		BroadcastLocalizedMessage( AnnouncerMessageClass, 1+7*TheFlag.Team.TeamIndex, ScorerPRI, None, TheFlag.Team );
		ScorerPRI.IncrementEventStat('EVENT_RETURNEDFLAG');
		ScorerPRI.IncrementHeroMeter(1.0);
		if (Dist>1024)
		{
			// figure out who's closer
			if (Dist<=oppDist)	// In your team's zone
			{
				ScorerPRI.Score += 3;
			}
			else
			{
				ScorerPRI.Score += 5;

				if (oppDist<=1024)	// Denial
				{
  					ScorerPRI.Score += 7;
				}

			}
		}
		return;
	}

	// Guy who caps gets 15
	ScorerPRI.bForceNetUpdate = TRUE;
	ScorerPRI.Score += 15;

	GoalsScored = ScorerPRI.IncrementEventStat('EVENT_SCOREDFLAG');
	PC = BTPlayerController(Scorer);
	if(PC != None) {
		PC.ClientMessage("!!! YOU SCORED A GOAL IN TIME = "
		$ class'UTHUD'.static.FormatTime(UTGRI.ElapsedTime -
						PC.TimerOffset));
		PC.TimerValue = 0;
		PC.TimerOffset = UTGRI.ElapsedTime;
		PC.SetServerTimerOffset(PC.TimerOffset);
	}
	if ( GoalsScored == 3 )
	{
		ScorerPRI.IncrementEventStat('EVENT_HATTRICK');
		if ( PC != None )
		{
			PC.ReceiveLocalizedMessage(TeamScoreMessageClass, 6, ScorerPRI);
		}
	}
	else
	{
		if ( PC != None )
		{
			PC.ReceiveLocalizedMessage(TeamScoreMessageClass, 7, ScorerPRI);
		}
	}

	// Apply the team score
	ScorerPRI.Team.Score += 1.0;
	ScorerPRI.Team.bForceNetUpdate = TRUE;

	CheckScore(ScorerPRI);

    if ( bOverTime )
    {
		EndGame(ScorerPRI,"timelimit");
    }
	Super(UTTeamGame).AnnounceScore(ScorerPRI.Team.TeamIndex);
}	

/** ChangeTeam()
* verify whether controller Other is allowed to change team, and if so change his team by calling SetTeam().
* @param Other:  the controller which wants to change teams
* @param num:  the teamindex of the desired team.  If 255, pick the smallest team.
* @param bNewTeam:  if true, broadcast team change notification
*/
function bool ChangeTeam(Controller Other, int num, bool bNewTeam)
{
	local UTTeamInfo NewTeam;

	// no team changes after initial change if single player campaign
	if ( (SinglePlayerMissionID != -1) && (Other.PlayerReplicationInfo.Team != None) )
	{
		return false;
	}

	// don't add spectators to teams
	if ( Other.IsA('PlayerController') && Other.PlayerReplicationInfo.bOnlySpectator )
	{
		Other.PlayerReplicationInfo.Team = None;
		return true;
	}

	NewTeam = (num < 255) ? Teams[PickTeam(num,Other)] : None;

	// check if already on this team
	if ( Other.PlayerReplicationInfo.Team == NewTeam )
	{
		// may have returned current team if not allowed to switch
		// if not allowed to switch, set up or complete proposed swap
		if ( (num < 2) && (num != NewTeam.TeamIndex) && !bPlayersVsBots && (PlayerController(Other) != None)
			&& (UTTeamInfo(Other.PlayerReplicationInfo.Team) != None) )
		{
			if(Teams[num] == None) {
				return false;
			} else {
				NewTeam = Teams[num];
			}
		}
	}

	// set the new team for Other
	SetTeam(Other, NewTeam, bNewTeam);
	return true;
}

defaultproperties
{
	TeamScoreMessageClass=Class'UTGameContent.UTTeamScoreMessage'
	HUDType=Class'BTHUD'
	PlayerReplicationInfoClass=class'BunnyTrailsGame.BTPRI'
	TeamAIType(0)=Class'UTGame.UTTeamAI'
	TeamAIType(1)=Class'UTGame.UTTeamAI'
	bMidGameHasMap=True
	Acronym="BT"
	Description="Bunny Trails is a fun way to improve movements skills which will give you the edge in all other game types. It is inspired by UT99's Bunny Tracks and UT2004's Trials."
	DefaultInventory(0)=Class'BunnyTrailsGame.BTWeap_Communicator'
	DefaultInventory(1)=None
	MapPrefixes(0)="BT"
	EndOfMatchRulesTemplateStr_Scoring="First team to reach the objective `g times wins. Press [Pause] to stop/start timer."
	EndOfMatchRulesTemplateStr_ScoringSingle="First team to reach the objective wins"
	GameName="Bunny Trails"
	PlayerControllerClass=Class'BunnyTrailsGame.BTPlayerController'
	OnlineGameSettingsClass=Class'UTGame.UTGameSettingsVCTF'
	DefaultPawnClass=Class'BunnyTrailsGame.BTPawn'
}

