/* 
    BattleTeamArena Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTeamArena.

    BattleTeamArena is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

class BattleMessage extends UTLocalMessage;

var string MessageText[10];

static function string GetString(
	optional int Switch,
	optional bool bPRI1HUD,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	local string N1, N2;

	if (RelatedPRI_1 == None)
		N1 = "someone";
	else
		N1 = RelatedPRI_1.GetPlayerAlias();

	if (RelatedPRI_2 == None)
		N2 = "someone";
	else
		N2 = RelatedPRI_2.GetPlayerAlias();

 	return Repl(Repl(Default.MessageText[Switch],"`1",N1),"`2",N2);
}

static simulated function ClientReceive(
	PlayerController P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	local UTHUD HUD;
	
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	HUD = UTHUD(P.myHUD);
	if ((HUD != None) && HUD.bIsSplitScreen && !HUD.bIsFirstPlayer)
	{
		return;
	}
	UTPlayerController(P).PlayAnnouncement(default.class, Switch);
}

// BattleTeamArena.uc
// function ServerBroadcastMessage (int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2)

// BattlePlayerController.uc
// reliable server function ServerShowMessage (int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2)
// reliable client function ClientShowMessage (int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2)


static function bool ShouldBeRemoved(UTQueuedAnnouncement MyAnnouncement, class<UTLocalMessage> NewAnnouncementClass, int NewMessageIndex)
{
  return true;
}

static function SoundNodeWave AnnouncementSound(int MessageIndex, Object OptionalObject, PlayerController PC)
{
//  if (MessageIndex == 1) { // BattlePlayerController.uc - spec
//	return SoundNodeWave'A_interface.Menu.UT3MenuWeaponSelect01';
//  }
  if (MessageIndex == 2 || MessageIndex == 3) { // BattlePawn.uc - getting thawed
    return SoundNodeWave'A_Ambient_NonLoops.HiTech.spark_large04'; // 0.73s
  }
  if (MessageIndex == 8 || MessageIndex == 9) { // BattlePawn.uc - thawing someone
    return SoundNodeWave'A_Ambient_NonLoops.HiTech.spark_large04'; // 0.73s
  }
  if (MessageIndex == 4) { // BattlePawn.uc - camp warning
	return SoundNodeWave'A_Pickups_Powerups.PowerUps.A_Powerup_UDamage_Warning'; // 1.17s
  }
  if (MessageIndex == 5) { // BattlePawn.uc - camp final warning
	return SoundNodeWave'A_Pickups_Powerups.PowerUps.A_Powerup_UDamage_Warning'; // 1.17s
  }
  if (MessageIndex == 6) { // BattlePawn.uc - back in the game
	return SoundNodeWave'A_interface.Menu.UT3ServerSignIn01';
  }
  if (MessageIndex == 7) { // BattleTeamArena.uc - last one standing
	return SoundNodeWave'A_Gameplay.CTF.WAV.A_Gameplay_CTF_FlagAlarm01'; // 1.27s
  }
  return SoundNodeWave'A_Gameplay.Gameplay.MessageBeep';
//    return SoundNodeWave'A_Vehicle_Generic.Vehicle.VehicleHorn'; // 1.04s
//    return SoundNodeWave'A_Vehicle_Cicada.Sounds.A_Vehicle_Cicada_TargetLock01';
//    return SoundNodeWave'A_Character_BodyImpacts.BodyImpacts.A_Character_RobotImpact_GibMedium02'; // 0.67s
//    return SoundNodeWave'A_interface.Menu.UT3MenuWeaponSelect01'; // 0.15s
//    return SoundNodeWave'A_Gameplay.CTF.WAV.A_Gameplay_CTF_FlagAlarm03'; // 1.03s
//    return SoundNodeWave'A_Pickups.Generic.WAV.A_Pickups_Generic_ItemRespawn01'; // 1.06s
//    return SoundNodeWave'A_Pickups_Powerups.PowerUps.A_Powerup_Invulnerability_Warning'; // 1.08s
//    return SoundNodeWave'A_Pickups_Powerups.PowerUps.A_Powerup_Invisibility_Warning'; // 1.42s
}

defaultproperties
{
   MessageText(0)="Test Message (N1:`1 N2:`2)"
   MessageText(1)="Now viewing `1"
   MessageText(2)="Your own view"
   MessageText(3)="`1 is thawing you!"
   MessageText(4)="Camping is not allowed!"
   MessageText(5)="Camping is not allowed! You will start losing health now."
   MessageText(6)="`1 is back in the game!"
   MessageText(7)="You are the last one standing!"
   MessageText(8)="You are thawing `1"
   MessageText(9)="You are thawing `1"
   MessageArea=2
   AnnouncementPriority=8
   bIsUnique=True
   DrawColor=(B=0,G=255,R=255,A=255)
   FontSize=2
}

