class BTWeap_Communicator extends UTWeap_InstagibRifle;

var bool bFirePressed;
var bool bAltFirePressed;

simulated function PostBeginPlay() {
	Super.PostBeginPlay();
	bForceHidden = true;
	AttachmentClass=Class'BTAttachment_Communicator';
}

simulated function DrawZoomedOverlay(HUD H) {
}

simulated function StartFire(byte FireModeNum) {
	local Pawn P;
	local BTPlayerController PC;
	P = Pawn(Owner);
	if(P != None) {
		PC = BTPlayerController(P.Controller);
	}
	if(PC != None) {
		if(FireModeNum == 1) {
			bAltFirePressed = true;
			if(!PC.bSpectating && bFirePressed) {
				PC.Toggle3rdPerson();
			} else {
				PC.SpectateSomeoneElse();
				PC.bSpectating = true;
			}
		} else {
			bFirePressed = true;
			if(PC.bSpectating && !bAltFirePressed){
				PC.ClientMessage("Stopped spectating");
				PC.SpectateSelf();
				PC.bSpectating = false;
			} else if(PC.bSpectating) {
				PC.Toggle3rdPerson();
			}
		}
	}
}

simulated function EndFire(byte FireModNum) {
	if(WorldInfo.NetMode != NM_DedicatedServer) {
		if(FireModNum == 1) {
			bAltFirePressed = false;
		} else {
			bFirePressed = false;
		}
	}
	Super.EndFire(FireModNum);
}
	

simulated function DrawWeaponCrosshair(Hud HUD) {
}

simulated event CauseMuzzleFlash() {
}

simulated function WeaponPlaySound(SoundCue Sound, optional float NoiseLoudness){
}

simulated function PlayFiringSound() {
}

simulated function Projectile ProjectileFire() {
	return None;
}

defaultproperties
{
   ItemName="Communicator"
   PickupMessage="Communicator"
}

