class BTPlayerController extends UTPlayerController;


//var BTFlashlight Flashlight;
/*
var bool bFlashlightEnabled;
var bool bFlashlightOn;
*/
var bool bSpectating;
var bool b3rdPerson;
var BTInteraction BTI;
var name LastHelpID;
var name LastEquipID;
var Object LongHelpMsg; // multiline help message
var int NextHelpLine; // next line to be shown
var bool bTimerStopped;
var float TimerValue;
var float TimerOffset; // ElapsedTime - TimerValue

var float Old_vZ;

replication
{
/*	reliable if(Role==ROLE_Authority)
		bFlashLightEnabled;

	unreliable if(Role==Role_Authority)
		UpdateFlashlight;

	reliable if(Role<=ROLE_AutonomousProxy)
		bFlashlightOn;
*/
}

simulated event PostBeginPlay() {
	Super.PostBeginPlay();
}

// walk through players and vehicles
event bool NotifyBump(Actor Other, Vector HitNormal) {
	if((Pawn(Other) != None) || (Vehicle(Other) != None)) {
		return false;
	}
	return true;
}

function bool CanSpectate (PlayerReplicationInfo PRI) {
	if (PRI == PlayerReplicationInfo) return false;
	return true;
}

reliable server function ServerShowMessage(int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2) {
	ClientShowMessage(Switch, RelatedPRI_1, RelatedPRI_2);
}

reliable client function ClientShowMessage(int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2) {
	ReceiveLocalizedMessage(class'BattleMessage', Switch, RelatedPRI_1, RelatedPRI_2);
}

/*
function UpdateFlashlight() {
	local BTPRI BTPRI;

	BTPRI = BTPRI(PlayerReplicationInfo);
	if(BTPRI != None && BTPRI.Flashlight != None) {
		BTPRI.Flashlight.Adjust(Pawn.Location +
				vect(0,0,1) * (Pawn.BaseEyeHeight + 6),
				Pawn.GetViewRotation(),
		(BTPRI.bFlashlightOn && BTPRI.bFlashlightEnabled)? 1: 2);
	}
}
*/

simulated function UpdateFlashlight() {
	local BTPawn BP;
	BP = BTPawn(Pawn);
	if(BP != None) {
		BP.ToggleFlashlight();
	}
}

/*
reliable server function ServerSetFlashlightOn(bool value) {
	bFlashlightOn = value;
}

simulated function ToggleFlashlight() {
	if(Flashlight != None) {
		if(bFlashlightOn == true) {
			bFlashlightOn = false;
		} else {
			bFlashlightOn = true;
		}
	}
	ServerSetFlashlightOn(bFlashlightOn);
}
*/

simulated function ToggleFlashlight() {
	local BTPawn BP;
	BP = BTPawn(Pawn);
	if(BP != None) {
		BP.ToggleFlashlight();
	}
}

reliable server function SetServerTimerOffset(float value) {
	TimerOffset = value;
}

reliable server function SetServerTimerStopped(bool value) {
	bTimerStopped = value;
}

function StopTimer() {
	bTimerStopped = true;
	SetServerTimerStopped(true);
}

function ResumeTimer() {
	local UTGameReplicationInfo UTGRI;

	UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
	TimerOffset = UTGRI.ElapsedTime - TimerValue;
	bTimerStopped = false;
	SetServerTimerStopped(false);
	SetServerTimerOffset(TimerOffset);
}

simulated event PlayerTick(float DeltaTime) {
	local vector HitLocation, HitNormal, T1, T2;
	local actor HitActor;
	local int ttt; // used for operations with timer
	local int tto; // used to store offset difference
	local UTGameReplicationInfo UTGRI;
	local BTPawn BP;

	UTGRI = UTGameReplicationInfo(WorldInfo.GRI);

	if(!bTimerStopped) {
		TimerValue = UTGRI.ElapsedTime - TimerOffset;
					// adjust timer offset
//					TimerValue += DeltaTime;
//					TimerOffset = UTGRI.ElapsedTime -
//						TimerValue;
//					SetServerTimerOffset(TimerOffset);
		if(TimerValue < 0) {
			TimerValue = 0;
			TimerOffset = UTGRI.ElapsedTime - TimerValue;
		} else if(TimerValue > UTGRI.ElapsedTime) {
			TimerValue = UTGRI.ElapsedTime;
			TimerOffset = UTGRI.ElapsedTime - TimerValue;
		}
	}

	if(BTI == None) {
		BTI = New(Self) class'BTInteraction';
		Interactions.Insert(0,1);
		Interactions[0] = BTI;
		BTI.Init();
		BTI.PC = Self;
	}

	Super.PlayerTick(DeltaTime);

//	UpdateFlashlight();
}

function Toggle3rdPerson() {
	if(b3rdPerson) {
		SetCameraMode('FirstPerson');
		b3rdPerson = false;
	} else {
		SetCameraMode('ThirdPerson');
		b3rdPerson = true;
	}
}

reliable server function SpectateSelf() {
	ServerShowMessage(2);
	SetViewTarget(Pawn);
	bSpectating = false;
	bTimerStopped = false;
}

reliable server function SpectateSomeoneElse() {
	local int i, CurrentIndex, NewIndex;
	local PlayerReplicationInfo PRI;
	local bool bSuccess;
	local int dir;
//	ViewAPlayer(1);
//	return;
	dir = 1;
	CurrentIndex = -1;
	if(RealViewTarget != None) {
		// Find index of current viewtarget's PRI
		For(i = 0; i < WorldInfo.GRI.PRIArray.Length; i++) {
			if(RealViewTarget == WorldInfo.GRI.PRIArray[i]) {
				CurrentIndex = i;
				break;
			}
		}
	}

	// Find next valid viewtarget in appropriate direction
	for(NewIndex = CurrentIndex + dir;
		(NewIndex >= 0) && (NewIndex < WorldInfo.GRI.PRIArray.Length);
						NewIndex = NewIndex + dir) {
		PRI = WorldInfo.GRI.PRIArray[NewIndex];
		if((PRI != None) && (Controller(PRI.Owner) != None) &&
					(Controller(PRI.Owner).Pawn != None) &&
							CanSpectate(PRI)) {
			bSuccess = true;
			break;
		}
	}

	if(!bSuccess) {
		// wrap around
		CurrentIndex = (NewIndex < 0)?
				WorldInfo.GRI.PRIArray.Length: -1;
		for(NewIndex = CurrentIndex + dir; (NewIndex >= 0) &&
				(NewIndex < WorldInfo.GRI.PRIArray.Length);
						NewIndex=NewIndex+dir) {
			PRI = WorldInfo.GRI.PRIArray[NewIndex];
			if((PRI != None) && (Controller(PRI.Owner) != None)
					&& (Controller(PRI.Owner).Pawn != None)
							&& CanSpectate(PRI)) {
				bSuccess = true;
				break;
			}
		}
	}

	if(bSuccess) {
		ServerShowMessage(1, PRI);
		ClientMessage("Spectating"@PRI.PlayerName);
		SetViewTarget(Controller(PRI.Owner).Pawn);
		bSpectating = true;
		bTimerStopped = true;
	}
}

event Possess(Pawn aPawn, bool bVehicleTransition) {
	Super.Possess(aPawn, bVehicleTransition);
	ResumeTimer();
}

event UnPossess() {
	Super.UnPossess();
	StopTimer();
}

function PawnDied(Pawn P) {
	Super.PawnDied(P);
	StopTimer();
}

/*
state BaseSpectating
{
	event BeginState(Name PreviousStateName) {
		Super.BeginState(PreviousStateName);
		StopTimer();
	}

	event EndState(Name NextStateName)
	{
		Super.EndState(NextStateName);
		ResumeTimer();
	}

	event PlayerTick(float DeltaTime) {
		local vector HitLocation, HitNormal, T1, T2;
		local actor HitActor;
		local UTGameReplicationInfo UTGRI;

		UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
		if(BTI == None) {
			BTI = New(Self) class'BTInteraction';
			Interactions.Insert(0,1);
			Interactions[0] = BTI;
			BTI.Init();
			BTI.PC = Self;
		}
		TimerValue = 0;
		TimerOffset = UTGRI.ElapsedTime - TimerValue;

		Super.PlayerTick(DeltaTime);

//		UpdateFlashlight();
	}

}
*/

auto state PlayerWaiting
{
	event BeginState(Name PreviousStateName) {
		Super.BeginState(PreviousStateName);
		StopTimer();
	}

	event EndState(Name NextStateName)
	{
		Super.EndState(NextStateName);
		ResumeTimer();
	}
	event PlayerTick(float DeltaTime) {
		local vector HitLocation, HitNormal, T1, T2;
		local actor HitActor;
		local UTGameReplicationInfo UTGRI;

		UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
		if(BTI == None) {
			BTI = New(Self) class'BTInteraction';
			Interactions.Insert(0,1);
			Interactions[0] = BTI;
			BTI.Init();
			BTI.PC = Self;
		}
		TimerValue = 0;
		TimerOffset = UTGRI.ElapsedTime - TimerValue;

		Super.PlayerTick(DeltaTime);

//		UpdateFlashlight();
	}
}

state RoundEnded
{
Begin:
	StopTimer();
}

State Dead
{
	event PlayerTick(float DeltaTime) {
		local vector HitLocation, HitNormal, T1, T2;
		local actor HitActor;

		if(BTI == None) {
			BTI = New(Self) class'BTInteraction';
			Interactions.Insert(0,1);
			Interactions[0] = BTI;
			BTI.Init();
			BTI.PC = Self;
		}

		Super.PlayerTick(DeltaTime);

//		UpdateFlashlight();
	}

	reliable server function ServerReStartPlayer() {
		LastHelpID = '';
		LastEquipID = '';
		Super.ServerReStartPlayer();
	}

	event EndState(Name NextStateName) {
		local UTGameReplicationInfo UTGRI;

		UTGRI = UTGameReplicationInfo(WorldInfo.GRI);
		Super.EndState(NextStateName);
		TimerValue = 0;
		TimerOffset = UTGRI.ElapsedTime - TimerValue;
		ResumeTimer();
		SetServerTimerOffset(TimerOffset);
	}
Begin:
	StopTimer();
}

defaultproperties
{
	bTimerStopped="false"
	bflashlightenabled="false"
	bflashlighton="true"
}

