class BTPawn extends UTPawn config(Game) notplaceable;

var BTFlashlight Flashlight;
var PointLightComponent DarkLight;
var bool bFlashlightEnabled;
var bool bFlashlightOn;
var bool bFeignDeathDisabled;
var BTPRI PR;

simulated function PostBeginPlay() {
	bFlashlightOn = true;
	bFlashlightEnabled = false;

	super.PostBeginPlay();
		// let players go through each other
	SetCollision(true, false);
//	SetTimer(2.0, false, 'AfterPostBeginPlay');
}

replication
{
	// sent to non owning clients
//	if(bNetDirty && (!bNetOwner || bDemoRecording)
//						&& Role==Role_Authority)
//		bFlashLightEnabled, bFlashlightOn;

	// Variables the server should send ALL clients.
//	if(bNetDirty && (Role==ROLE_Authority))
	if(Role==ROLE_Authority)
		bFlashLightEnabled,
		bFeignDeathDisabled;
	if(Role<ROLE_Authority)
		bFlashlightOn;
}

simulated function bool StopsProjectile(Projectile P) {
	if((UTProj_StingerShard(P) != None)) {
		return true;
	} else {
		return false;
	}
}

event TakeDamage(int Damage, Controller InstigatedBy, vector HitLocation,
	vector Momentum, class<DamageType> DamageType,
	optional TraceHitInfo HitInfo, optional Actor DamageCauser) {
//	`log(DamageType.Name);
		// ignore damage done by players (no matter which team)
	if((InstigatedBy != None) && (InstigatedBy != Controller)) {
		return;
	}
	Super.TakeDamage(Damage, InstigatedBy, HitLocation, Momentum,
		DamageType, HitInfo, DamageCauser);
}

function bool No_Feign() {
	return bFeignDeathDisabled;
}

reliable server function ServerSetFlashlightOn(bool value) {
	bFlashlightOn = value;
}

reliable server function ServerFeignDeath() {
	if(No_Feign() == false || IsInState('FeigningDeath')) {
		Super.ServerFeignDeath();
	}
}

exec simulated function FeignDeath() {
	if(No_Feign() == false || IsInState('FeigningDeath')) {
		Super.FeignDeath();
	}
}

simulated function PlayFeignDeath() {
	if(No_Feign() == false || IsInState('FeigningDeath')) {
		Super.PlayFeignDeath();
	}
}

simulated event Tick(float DeltaTime) {
	super.Tick(DeltaTime);
/*
	if(Flashlight == None) {
		Flashlight = Spawn(class'BTFlashLight', self,,,,, TRUE);
		bFlashlightEnabled = true;
		bFlashlightOn = true;
	}
*/
	UpdateFlashlight();
}

simulated function UpdateFlashlight() {
	if(IsInState('Dying')) {
		if(Flashlight != None) {
			Flashlight.Destroy();
			//`log("Nomore flashlight");
		}
	} else {
		if(Flashlight == None) {
			Flashlight =
				Spawn(class'BTFlashlight', self,,,,, TRUE);
				//`log("Creating a flashlight");
		}

		if(Flashlight != None) {
			Flashlight.Adjust(Location +
					vect(0,0,1) * (BaseEyeHeight + 6),
				GetBaseAimRotation(),//GetViewRotation(),
			(bFlashlightOn && bFlashlightEnabled)? 1: 2);
		}
	}
//	}
/*	if(BC.Flashlight == None) {
		BC.Flashlight = Spawn(class'BTFlashLight', self,,,,, TRUE);
	}

	if(Flashlight != None) {
		Flashlight.Adjust(Location +
				vect(0,0,1) * (BaseEyeHeight + 6),
				GetViewRotation(),
		(bFlashlightOn && bFlashlightEnabled)? 1: 2);
	}
*/
}

function ToggleFlashlight() {
	if(bFlashlightOn == true) {
		bFlashlightOn = false;
	} else {
		bFlashlightOn = true;
	}
	ServerSetFlashlightOn(bFlashlightOn);
}

simulated function OnBTHelpMessage(SeqAct_BTHelpMessage InAction) {
	local BTPlayerController BC;
//	bFeignDeathDisabled = true;
	BC = BTPlayerController(Controller);
	if(BC != None) {
		if(BC.LastHelpID != (InAction.Name)) {
			BC.ReceiveLocalizedMessage(class'BTHelpMessage', 0, , ,
								InAction);
			BC.LastHelpID = InAction.Name;
		}
	}
}

simulated function OnBTEquip(SeqAct_BTEquip InAction) {
	local BTPlayerController BC;
	BC = BTPlayerController(self.Controller);
	if(BC != None) {
		if(BC.LastEquipID == self.Name) {
			return;
		} else {
			BC.LastEquipID = self.Name;
		}
	}
	Equip(InAction.GetE());
}

simulated function Equip(int e) {
	local Inventory W;
	local UTInventory UW;
	local Weapon WP;
	local BTPlayerController BC;

	BC = BTPlayerController(Controller);

	if(InvManager == None) {
		return;
	}

	if((e & 1) != 0) {
		// we do have to take something
		if((e & (1 << 6)) != 0) {
				// bDestroyAllOtherWeapons
			foreach InvManager.InventoryActors(class'Weapon', WP) {
				if(BTWeap_Communicator(WP) == None &&
				UTWeap_ImpactHammer(WP) == None &&
				UTWeap_InstagibRifle(WP) == None) {
					WP.StopFire(WP.CurrentFireMode);
					InvManager.RemoveFromInventory(WP);
				}
			}
		}
		if((e & (1 << 8)) != 0) {
				// bDestroyAllOtherPickups
			foreach InvManager.InventoryActors(class'UTInventory',
									UW) {
				InvManager.RemoveFromInventory(UW);
			}
		}
		if((e & (1 << 3)) != 0) {
				// bDestroyImpact
			W = FindInventoryType(class'BunnyTrailsGame.BTWeap_ImpactHammer');
			if(W != None) {
				if(UTWeap_ImpactHammer(Weapon) != None) {
					Weapon = None;
					ThrowActiveWeapon();
				}
				InvManager.RemoveFromInventory(W);
			}
		}
		if((e & (1 << 4)) != 0) {
				// bDestroyEnforcer
			W = FindInventoryType(class'UTGame.UTWeap_Enforcer');
			if(W != None) {
				if(UTWeap_Enforcer(Weapon) != None) {
					Weapon = None;
					ThrowActiveWeapon();
				}
				InvManager.RemoveFromInventory(W);
			}
		}
		if((e & (1 << 5)) != 0) {
				// bDestroyInsta
			W = FindInventoryType(class'UTGame.UTWeap_InstagibRifle');
			if(W != None) {
				if(UTWeap_ImpactHammer(Weapon) != None) {
					Weapon = None;
					ThrowActiveWeapon();
				}
				InvManager.RemoveFromInventory(W);
			}
		}
		if((e & (1 << 2)) != 0) {
				// bDestroyHover
			bHasHoverBoard = false;
		}
		if((e & (1 << 1)) != 0) {
				// bDestroyFlashlight
			bFlashlightEnabled = false;
			bFlashlightEnabled = false;
//			UpdateFlashlight();
		}
		if((e & (1 << 7)) != 0) {
				// bDisableFeignDeath
			bFeignDeathDisabled = true;
		}
	}
	if((e & (1 << 15)) != 0) {
			// giving inventory / enabling stuff
		if((e & (1 << 22)) != 0) {
				// bEnableFeignDeath
			bFeignDeathDisabled = false;
		}
		if((e & (1 << 16)) != 0) {
				// bEquipWithFlashlight
			if(!bFlashlightEnabled) {
				bFlashlightEnabled = true;
				bFlashlightOn = true;
//				UpdateFlashlight();
			}
		}
		if((e & (1 << 17)) != 0) {
				// bEquipWithHover
			bHasHoverBoard = true;
			UTVehicle_Hoverboard(DrivenVehicle).DriverEnter(self);
		}
		if((e & (1 << 18)) != 0) {
				// bEquipWithImpact
			W = CreateInventory(class'BunnyTrailsGame.BTWeap_ImpactHammer');
			InvManager.SetCurrentWeapon(Weapon(W));
		}
		if((e & (1 << 19)) != 0) {
				// bEquipWithEnforcer
			W = CreateInventory(class'UTGame.UTWeap_Enforcer');
			InvManager.SetCurrentWeapon(Weapon(W));
		}
		if((e & (1 << 20)) != 0) {
				// bEquipWithInsta
			W = CreateInventory(class'UTGame.UTWeap_InstagibRifle');
			InvManager.SetCurrentWeapon(Weapon(W));
		}
	}
	if(((e & (1 << 14)) == 0) && (BC != None)) {
		if(((e & (1 << 15)) != 0) || ((e & 1) != 0)) {
			// something was given or taken
			BC.ReceiveLocalizedMessage(class'BTEquipMessage', e);
		}
	}
}

defaultproperties
{
	Name="BTPawn"
	bProjTarget="false"
	bflashlightenabled="false"
	bflashlighton="false"
}

