class BTInteraction extends Interaction within BTPlayerController;

var BTPlayerController PC;
var bool bF3Pressed;
var bool bF4Pressed;
var float TimeF1Pressed;
var bool bPausePressed;

function bool InputKey (int ControllerId, name Key, EInputEvent EventType, optional float AmountDepressed=1.f, optional bool bGamepad) {
	if(PC != None) {
		if(Key == 'F3') {
			if(EventType == IE_Pressed) {
				bF3Pressed = true;
				if(!PC.bSpectating && bF4Pressed) {
					PC.Toggle3rdPerson();
				} else {
					PC.SpectateSomeoneElse();
					PC.bSpectating = true;
				}
			} else if(EventType == IE_Released) {
				bF3Pressed = false;
			}
		} else if(Key == 'F4') {
			if(EventType == IE_Pressed) {
				bF4Pressed = true;
				if(PC.bSpectating && (bF3Pressed == false)){
					PC.ClientMessage("Stopped spectating");
					PC.SpectateSelf();
					PC.bSpectating = false;
				} else if(PC.bSpectating) {
					PC.Toggle3rdPerson();
				}
			} else if(EventType == IE_Released) {
				bF4Pressed = false;
			}
		} else if(Key == 'F1') {
			if(EventType == IE_Pressed) {
				TimeF1Pressed = WorldInfo.RealTimeSeconds;
			} else if(EventType == IE_Released) {
				if(BTPawn(PC.Pawn) != None &&
					((WorldInfo.RealTimeSeconds -
						TimeF1Pressed) < 0.1)) {
					PC.ToggleFlashlight();
				}
			}
		} else if(Key == 'Pause') {
			if(EventType == IE_Pressed) {
				bPausePressed = true;
			} else if(EventType == IE_Released) {
				if(PC.bTimerStopped == false) {
					PC.bTimerStopped = true;
				} else {
					PC.bTimerStopped = false;
					PC.TimerOffset =
	UTGameReplicationInfo(WorldInfo.GRI).ElapsedTime - PC.TimerValue;
					PC.SetServerTimerOffset(PC.TimerOffset);
				}
				bPausePressed = false;
			}
		}
	}
	return false;
}

defaultproperties
{
   __OnReceivedNativeInputKey__Delegate=Default__BTInteraction.InputKey
}

