class BTRamp extends TriggerVolume placeable;

// version 1.1 20090623 by arDru

var() vector FaceNormal;
var bool bDemandFaceNormal;

struct ContactData {
	// last correction time
	var float CTime;
	// touching actor
	var Actor A;
	// old velocity
	var vector OldVel;
};

var array<ContactData> CD;

simulated event Touch(Actor Other, PrimitiveComponent OtherComp,
				vector HitLocation, vector HitNormal) {
	local float Time;
	local int i;
	local Pawn P;
	local ContactData D; // used inside foreach
	local ContactData DD; // used outside foreach

	if((FaceNormal.Z == 0) || (bDemandFaceNormal)) {
		bDemandFaceNormal = True;
		WorldInfo.Game.Broadcast(Other, Name $ " FaceNormal= "
			$ HitNormal.X $ " "
			$ HitNormal.Y $ " "
			$ HitNormal.Z
		$ " - map maker must set this parameter in Editor. -arDru"
			, 'Event');
	}

	DD.CTime = 0;
	Time = WorldInfo.TimeSeconds;
	P = Pawn(Other);

	if(P == None) {
		return;
	}

	foreach CD(D, i) {
		if(D.A == Other) {
			DD = D;
			break;
		}
	}

		// if no contact data exist for this object, create one entry
	if(DD.CTime == 0) {
		CD.Insert(0,1);
		DD.CTime = Time;
		i = 0;
	}

	DD.A = Other;
	if(bDemandFaceNormal) {
		FaceNormal = HitNormal;
	}
	CD[i] = DD;

	super.Touch(Other, OtherComp, HitLocation, HitNormal);
	PendingTouch = Other.PendingTouch;
	Other.PendingTouch = self;
}

simulated event UnTouch(Actor Other) {
	// we can now delete the ContactData entry associated with this actor
	local int i;
	local ContactData D; // used inside foreach
	foreach CD(D, i) {
		if(D.A == Other) {
			CD.Remove(i, 1);
			break;
		}
	}
	return;
}

simulated event PostTouch(Actor Other) {
	local float Time; // current time
	local Pawn P;
	local ContactData D; // used for iterations
	local ContactData ActiveD; // an active actor, pawn
	local int i;
	local float VProjHN; // Velocity projection on HitNormal
	local float OVProjHN; // Old Velociy's projection on HitNormal
	local vector DeltaV; // delta of velocity
	local vector MirrorDV; // mirror of delta v around the hit normal
	local vector NewVel;

	super.PostTouch(Other);

	// There can be several actors touching this volume, so we need to
	// process all actors in our list, since PostTouch is only called once

	Time = WorldInfo.TimeSeconds;

	foreach CD(D, i) {
		P = Pawn(D.A);
		// check if actor (still) exists
		if(P == None) {
			CD.Remove(i, 1);
			continue;
		}

		// if velocity is completely zero - nothing to do here.
		// also check if OldVel is set, otherwise initialize it first
		if((D.A.Velocity == vect(0, 0, 0)) ||
			(D.OldVel == vect(0, 0, 0))) {
			goto cont;
		}

		// checking if actor's vertical velocity.z is positive
		if(!(D.A.Velocity.Z >= 0.0)) {
			goto cont;
		}
		// checking if actor's |velocity projection to hitNormal| has
		// diminished, which means that actor is hitting underlying
		// surface, otherwise ignore this actor for now
		VProjHN = abs((D.A.Velocity dot FaceNormal));
		OVProjHN = abs((D.OldVel dot FaceNormal));

		if(!((VProjHN - OVProjHN) < (-1.0))) {
			goto cont;
		}

		DeltaV = D.A.Velocity - D.OldVel;
		MirrorDV = 2 * ((DeltaV dot FaceNormal) * FaceNormal) -
								DeltaV;
		NewVel = D.OldVel + MirrorDV;
		if(NewVel.Z < D.A.Velocity.Z) {
			// the boost must be boosty
			goto cont;
		}

		// adjust actor's velocity
		D.A.Velocity = NewVel;
		P.SetPhysics(PHYS_Falling);

cont:
		D.OldVel = D.A.Velocity;
		if(ActiveD.CTime == 0) {
			ActiveD = D;
		}
		D.CTime = Time;
		CD[i] = D;
	}
	if(ActiveD.CTime != 0) {
		PendingTouch = ActiveD.A.PendingTouch;
		ActiveD.A.PendingTouch = self;
	}
}

defaultproperties
{

}

