// Smiling Monsters FPH Alarm
// By Ti-Lung 13/09/2007
// Version 1.2 (20070913)
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class SMoFPHAlarm expands Mutator
	config(SMoFPHAlarm);

// config variable
var config bool bKick, bBan, bMessagePlayer, bUseOutsideLog;
var config int
	FPHLimitNormal,
	FPHLimitInstaGib,
	NegativeScoreLimit,
	TeamKillLimit,
	NumFragVerify;

// Internal variable
var bool bInitialized;
var int FPHLimit;
var int SuicideCount[32], TeamKillCount[32];
var float FPHDelta;
var FPHAlarmLog LogClass;

function PreBeginPlay()
{
	local Mutator M;

	if ( bInitialized )
		return;

	bInitialized = True;
	Log("Mutator initialized.",'SMoFPHAlarm');

	if( Level.netMode != NM_DedicatedServer )
	{
		log("This mutator will only function on a dedicated server",'SMoFPHAlarm');
		log("Disable mutator",'SMoFPHAlarm');
		Self.Destroy(); // mutator not necessary so destroy
	}

	// Verify if InstagibDM or SniperArena mutator
	for( M = Level.Game.BaseMutator; M != None; M = M.NextMutator )
	{
		if(
			M.class == class'Botpack.InstaGibDM'
			|| M.class == class'Botpack.SniperArena'
		)
		{
			FPHLimit = FPHLimitInstaGib; // Set instagib fphlimit
			break;
		}
	}

	if( FPHLimit == 0 )
		FPHLimit = FPHLimitNormal;

	if ( NextMutator != None )
		NextMutator.PreBeginPlay();

	// Spawn log class and start log
	LogClass = Spawn( class'FPHAlarmLog' );

	if ( LogClass != none )
		LogClass.StartLog();
}

// UT call to scorekill function when player get a frag
function ScoreKill( Pawn Killer, Pawn Other )
{
	local bool bFPH, bSuicide, bTeamKill;
	local int KillerScore, PID;
	local float PlayerTime, PlayerJoinTime, GameTime, FPH;
	local string IP, ClientMessage, Playername;

	if( Killer.IsA('PlayerPawn') ) // Verify real player
	{
		// Verify that Killer has replicationinfo to stop accessed none
		if( Killer.PlayerReplicationInfo != none )
		{
			KillerScore = Killer.PlayerReplicationInfo.Score;

			// Calculate time that player is in match
			PlayerTime =
				Level.TimeSeconds
				- Killer.PlayerReplicationInfo.StartTime;

			if( KillerScore	>= NumFragVerify )
			{
				// Calculate frag per hour
				// The value is lower than fph in f1 because time is float
				// and not int.
				FPH = ( KillerScore / PlayerTime ) * 3600;

				// Uncomment line to see fph in message
				// Killer.ClientMessage("FPH"@FPH);

				// FPH verify
				if( FPH >= FPHLimit )
				{
					if( bUseOutsideLog )
						OutsideLog("Exceed FPH Limit:"@FPH);
					else
						log("Exceed FPH Limit:"@FPH,'SMoFPHAlarm');

					bFPH = true;
				}
			}

			// If gametype is Team DeathMatch
			if(
				Level.Game.IsA('TeamGamePlus')
				// Assault, CTFGame, Domination are child of TeamGamePlus
				&& !ClassIsChildOf(Level.Game.Class,class'Botpack.TeamGamePlus')
			)
			{
				// Get PlayerID of killer pawn
				PID = PawnToPlayerID( Killer );

				// Suicide. Does not detect console suicide
				if( KillerScore <= 0 )
				{
					if( Killer == Other )
					{
						SuicideCount[ PID ] += 1;

						if( SuicideCount[ PID ] >= -NegativeScoreLimit )
						{
							if( bUseOutsideLog )
								OutsideLog("Exceed Suicide Limit"@SuicideCount[ PID ]);
							else
								log("Exceed Suicide Limit"@SuicideCount[ PID ],'SMoFPHAlarm');

							bSuicide = true;
						}
					}
				}

				// Team kill
				if(
					Killer.PlayerReplicationInfo.Team
					== Other.PlayerReplicationInfo.Team
				)
				{
					TeamKillCount[ PID ] += 1;

					if( TeamKillCount[ PID ] >= TeamKillLimit )
					{
						if( bUseOutsideLog )
							OutsideLog("Exceed TeamKill Limit"@TeamKillCount[ PID ]);
						else
							log("Exceed TeamKill Limit"@TeamKillCount[ PID ],'SMoFPHAlarm');
					}
				}
			}

			// Log player information and kick/ban
			if( bFPH || bSuicide || bTeamKill )
			{
				// Get network address and remove ":" plus port number
				IP = left(
					PlayerPawn( Killer ).GetPlayerNetworkAddress(),
					Instr( PlayerPawn( Killer ).GetPlayerNetworkAddress(),
					":"));

				Playername = Killer.PlayerReplicationInfo.PlayerName;

				if( bUseOutsideLog )
				{
					OutsideLog("PlayerName"@PlayerName);
					OutsideLog("PlayerID"@Killer.PlayerReplicationInfo.PlayerID);
					OutsideLog("PlayerIP"@IP);
				}
				else
				{
					log("PlayerName"@PlayerName,'SMoFPHAlarm');
					log("PlayerID"@Killer.PlayerReplicationInfo.PlayerID,'SMoFPHAlarm');
					log("PlayerIP"@IP,'SMoFPHAlarm');
				}

				// Kick player
				if( bKick )
				{
					log("Kick:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');

					// Set string for client message
					if( bFPH )
						ClientMessage = "Exceed FPH Limit on server";
					if( bSuicide )
						ClientMessage = "Exceed Suicide Limit on server";
					if( bTeamKill )
						ClientMessage = "Exceed Teamkill Limit on server";

					if( bMessagePlayer )
					{
						Killer.ClientMessage( "Kick:" @ ClientMessage );
					}

					Killer.Destroy(); // Destroy Pawn and disconnect player

					// Reset player counter
					SuicideCount[ PID ] = 0;
					TeamKillCount[ PID ] = 0;
				}

				// Ban player
				if( bBan )
				{
					log("Ban:"@Killer.PlayerReplicationInfo.PlayerName,'SMoFPHAlarm');
					BanIP( IP );
				}
			}
		}
	}

	// Execute scorekill of next mutator
	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

// Stop log
function bool HandleEndGame()
{
	if ( LogClass != none )
	{
		LogClass.StopLog();
		LogClass.Destroy();
		LogClass = None;
	}
}

/* Custom function */

// Return playerid of a pawn
function int PawnToPlayerID( Pawn aPawn )
{
	local Pawn P;

	P = Level.PawnList;

	while ( P != none )
	{
		if( P.IsA('PlayerPawn') || P.IsA('Bot') )
		{
			if( P == aPawn )
				return P.PlayerReplicationInfo.PlayerID;
		}

		P = P.nextPawn;
	}

	return -1; // Should not happen
}

// Ban function from HiddenAdmin
function bool BanIP( string IPString )
{
	local int i;

	if ( Level.Game.CheckIPPolicy( IPString ) )
	{
		for (i=0; i<50; i++)
		{
			if ( Level.Game.IPPolicies[i] == "" )
			{
				break; // exit iterator
			}
		}

		if (i<50)
		{
			Level.Game.IPPolicies[i] = "DENY,"$IPString;
			Level.Game.SaveConfig();
			return true;
		}
	}

	return false;
}

// Log to outside file
function OutsideLog( string aString )
{
	local Pawn P;

	if( LogClass != none )
	{
		LogClass.LogEventString( aString );
		LogClass.FileFlush();
	}

	Log( aString ); // Log to server ini also
}

defaultproperties
{
	bBan=False
	bKick=false
	bUseOutsideLog=True
	FPHLimitNormal=600
	FPHLimitInstaGib=1900
	NegativeScoreLimit=-10
	NumFragVerify=6
	TeamKillLimit=10
}
