//=============================================================================
// NyanCat Deemer: NyanCatDeemer
//=============================================================================
class NyanCatDeemer extends TournamentWeapon;

#exec OBJ LOAD FILE=Textures\NyanCam.utx PACKAGE=NyanCatDeemer.Skins
#exec OBJ LOAD FILE=Textures\Crashed.utx  PACKAGE=NyanCatDeemer.Skins
#exec TEXTURE IMPORT NAME=NyanScope FILE=Textures\NyanScope.PCX GROUP="Skins"  LODSET=2
#exec TEXTURE IMPORT NAME=NyanVisible FILE=Textures\NyanVisible.PCX GROUP="Skins"  LODSET=2

var NyanCatGuidedWarShell GuidedShell;
var int Scroll;
var PlayerPawn GuidingPawn;
var bool	bGuiding, bCanFire, bShowStatic;
var rotator StartRotation;

replication
{
	// Things the server should send to the client.
	reliable if( bNetOwner && (Role==ROLE_Authority) )
		bGuiding, bShowStatic;
}

function SetWeaponStay()
{
	bWeaponStay = false; // NyanCat Deemer never stays
}

simulated function PostRender( canvas Canvas )
{
	local int i, numReadouts, OldClipX, OldClipY;
	local float Scale;

	bOwnsCrossHair = ( bGuiding || bShowStatic );

	if ( !bGuiding )
	{
		if ( !bShowStatic )
			return;

		Canvas.SetPos( 0, 0);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawIcon(Texture'Static_a00', FMax(Canvas.ClipX, Canvas.ClipY)/256.0);
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).ViewTarget = None;
		return;
	}
	GuidedShell.PostRender(Canvas);
	OldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	Scale = Canvas.ClipX/256;
	Canvas.SetPos( 0.5 * OldClipX - 128 * Scale, 0.5 * OldClipY - 128 * Scale );
	Canvas.Style = ERenderStyle.STY_Modulated;
	Canvas.DrawIcon(Texture'NyanGuided01', Scale);
	Scale = Canvas.ClipX/640;
	Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
	Canvas.DrawIcon(Texture'NyanScope', Scale);
	Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
	Canvas.Style = ERenderStyle.STY_Translucent;
}	

function float RateSelf( out int bUseAltMode )
{
	local Pawn P, E;
	local Bot O;

	O = Bot(Owner);
	if ( (O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None) )
		return -2;

	bUseAltMode = 0;
	E = O.Enemy;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && (P != O) && (P != E)
			&& (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team))
			&& (VSize(E.Location - P.Location) < 650) 
			&& (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2)
			&& FastTrace(P.Location, E.Location) )
		{
			if ( VSize(E.Location - O.Location) > 500 )
				return 2.0;
			else
				return 1.0;
		}

	return 0.35;
}

// return delta to combat style
function float SuggestAttackStyle()
{
	return -1.0;
}

simulated function PlayFiring()
{
	PlayAnim( 'Fire', 0.3 );		
	PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
}

function setHand(float Hand)
{
	if ( Hand == 2 )
	{
		bHideWeapon = true;
		return;
	}
	else
		bHideWeapon = false;

	PlayerViewOffset.Y = Default.PlayerViewOffset.Y;
	PlayerViewOffset.X = Default.PlayerViewOffset.X;
	PlayerViewOffset.Z = Default.PlayerViewOffset.Z;
	
	PlayerViewOffset *= 100; //scale since network passes vector components as ints
}

function AltFire( float Value )
{
	if ( !Owner.IsA('PlayerPawn') )
	{
		Fire(Value);
		return;
	}

	if (AmmoType.UseAmmo(1))
	{
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		PlayFiring();
		GuidedShell = NyanCatGuidedWarShell(ProjectileFire(AltProjectileClass, ProjectileSpeed, bWarnTarget));
		GuidedShell.SetOwner(Owner);
		PlayerPawn(Owner).ViewTarget = GuidedShell;
		GuidedShell.Guider = PlayerPawn(Owner);
		ClientAltFire(0);
		GotoState('Guiding');
	}
}

simulated function bool ClientAltFire( float Value )
{
	if ( bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0)) )
	{
		if ( Affector != None )
			Affector.FireEffect();
		PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
		return true;
	}
	return false;
}

State Guiding
{
	function Fire ( float Value )
	{
		if ( !bCanFire )
			return;
		if ( GuidedShell != None )
			GuidedShell.Explode(GuidedShell.Location,Vect(0,0,1));
		bCanClientFire = true;

		GotoState('Finishing');
	}

	function AltFire ( float Value )
	{
		Fire(Value);
	}

	function BeginState()
	{
		Scroll = 0;
		bGuiding = true;
		bCanFire = false;
		if ( Owner.IsA('PlayerPawn') )
		{
			GuidingPawn = PlayerPawn(Owner);
			StartRotation = PlayerPawn(Owner).ViewRotation;
			PlayerPawn(Owner).ClientAdjustGlow(-0.2,vect(200,0,0));
		}
	}

	function EndState()
	{
		bGuiding = false;
		if ( GuidingPawn != None )
		{
			GuidingPawn.ClientAdjustGlow(0.2,vect(-200,0,0));
			GuidingPawn.ClientSetRotation(StartRotation);
			GuidingPawn = None;
		}
	}


Begin:
	Sleep(1.0);
	bCanFire = true;
}

State Finishing
{
	ignores Fire, AltFire;

	function BeginState()
	{
		bShowStatic = true;
	}

Begin:
	Sleep(0.3);
	bShowStatic = false;
	Sleep(1.0);
	GotoState('Idle');
}

defaultproperties
{
     InstFlash=-0.400000
     InstFog=(X=950.000000,Y=650.000000,Z=290.000000)
     AmmoName=Class'Botpack.WarHeadAmmo'
     ReloadCount=1
     PickupAmmoCount=1
     bWarnTarget=True
     bAltWarnTarget=True
     bSplashDamage=True
     bSpecialIcon=True
     FiringSpeed=1.000000
     FireOffset=(X=18.000000,Z=-10.000000)
     ProjectileClass=Class'nyancatdeemer.NyanCatWarshell'
     AltProjectileClass=Class'nyancatdeemer.NyanCatGuidedWarshell'
     shakemag=350.000000
     shaketime=0.200000
     shakevert=7.500000
     AIRating=1.000000
     RefireRate=0.250000
     AltRefireRate=0.250000
     FireSound=Sound'Botpack.Redeemer.WarheadShot'
     SelectSound=Sound'Botpack.Redeemer.WarheadPickup'
     DeathMessage="%o was vaporized by %k's %w!!"
     NameColor=(G=128,B=128)
     AutoSwitchPriority=10
     InventoryGroup=10
     PickupMessage="The Nyan Cat"
     ItemName="Nyan Cat Deemer"
     RespawnTime=60.000000
     PlayerViewOffset=(X=1.800000,Y=1.000000,Z=-1.890000)
     PlayerViewMesh=LodMesh'Botpack.WarHead'
     BobDamping=0.975000
     PickupViewMesh=LodMesh'Botpack.WHPick'
     ThirdPersonMesh=LodMesh'Botpack.WHHand'
     StatusIcon=Texture'Botpack.Icons.UseWarH'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=Texture'Botpack.Icons.UseWarH'
     Mesh=LodMesh'Botpack.WHPick'
     bNoSmooth=False
     CollisionRadius=45.000000
     CollisionHeight=23.000000
}
