// Enhanced MH Beta
// By Ti-Lung 2007
// Version Beta 20070913
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class EnhancedMH expands Mutator
	config(EnhancedMH);

#exec OBJ LOAD FILE="..\Sounds\AmbOutside.uax"
#exec OBJ LOAD FILE="..\Sounds\Addon1.uax"
#exec OBJ LOAD FILE="..\System\UnrealI.u"
#exec OBJ LOAD FILE="..\System\BotPack.u"
#exec OBJ LOAD FILE="..\System\MonsterHunt.u"

var bool bInitialized;

// Config ammo
var config bool bRegenAmmo;
var config float PlusAmmo;
var config int RespawnTime;
var config int NewWeaponAmmoPercent;
var config bool bExcludeRedeemer;
var config bool bExcludeOtherWeapon;
var config name ExcludeAmmo[10];

// Config weapon
var config bool bChangetoUTWeapons;

// Config health
var config bool bRegenHealth;
var config float PlusHealth;
var config int RegenHealthLimit;

// Config monster
var config bool bChangeTrooperWeapon;

// Config event
var bool SpecialEvent;
var config bool bEarthQuake;
var config bool bSurpriseAttack;
var float AttackCounter;
var config int AttackInterval;

// Quake
var config int
    BeginWaitTime,
    WaitTime,
    IntervalMin,
    IntervalMax,
    DurationMin,
    DurationMax,
    MagnitudeMin,
    MagnitudeMax;

var float RemainingTime, QuakeCounter;
var int QuakeInterval, Duration, Magnitude;

// Temp variable
var float AddAmmo[32];
var float AddHealth[32];
var bool bAmmoChange;

var float TimerRate;

var float NumMonsterEnd;

function PostBeginPlay()
{
	local MonsterEnd ME;
	local int MonsterEndCounter;
	local Panel EMHPanel;

	// Exit if mutator is initialized
	if (bInitialized)
		return;

	bInitialized = True;
	Log("Mutator initialized.",'EnhancedMH');

    // Check Max and Min config variable
    if( IntervalMin > IntervalMax )
    {
        log("IntervalMin must be lower than IntervalMax. Swap value.",'SMoEarthQuake');
        SwapInt( IntervalMin, IntervalMax );
    }
    if( DurationMin > DurationMax )
    {
        log("DurationMin must be lower than DurationMax. Swap value.",'SMoEarthQuake');
        SwapInt( DurationMin, DurationMax );
	}
	if( MagnitudeMin > MagnitudeMax )
    {
        log("MagnitudeMin must be lower than MagnitudeMax. Swap value.",'SMoEarthQuake');
        SwapInt( MagnitudeMin, MagnitudeMax );
	}

	SaveConfig();

	// Count MonsterEnd trigger
	foreach AllActors( class'MonsterEnd', ME )
	{
		NumMonsterEnd += 1;
	}

	NumMonsterEnd = ceiling( NumMonsterEnd/2 );

	// Spawn EMHPanel on middle monsterend
	// Modify so it will spawn at game end near to player
	foreach AllActors( class'MonsterEnd', ME )
	{
		MonsterEndCounter += 1;
		if( MonsterEndCounter == NumMonsterEnd )
		{
			EMHPanel = Spawn(class'EMHPanel',,,ME.location+vect(0,0,14),class'EMHPanel'.default.rotation);

			if( EMHPanel == none )
				log("Unable to spawn MonsterEnd Panel !",'EnhancedMH');
		}
	}

	SetTimer( TimerRate, true );

	Level.Game.RegisterDamageMutator(Self);

	// if there is another mutator execute the postbeginplay
	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}


function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
    // Modify respawn time
	if ( Other.IsA('Weapon') )
	{
		Weapon(Other).RespawnTime = RespawnTime;
	}

	if ( Other.IsA('Ammo') )
	{
		Ammo(Other).RespawnTime = RespawnTime;
	}

	// Replace standard bot with bot that do not shoot friend monster
	/*  Does not function correct. Produce green bot.
	if(
		Other.IsA('TMale1Bot')
		&& Other.class!=class'EnhancedMH.EMHTMale1Bot'
	)
	{
		ReplaceWith( Other, "EnhancedMH.EMHTMale1Bot" );
	}
	if(
		Other.IsA('TMale2Bot')
		&& Other.class!=class'EnhancedMH.EMHTMale2Bot'
	)
	{
		ReplaceWith( Other, "EnhancedMH.EMHTMale2Bot" );
	}
	if(
		Other.IsA('TFemale1Bot')
		&& Other.class!=class'EnhancedMH.EMHTFemale1Bot'
	)
	{
		ReplaceWith( Other, "EnhancedMH.EMHTFemale1Bot" );
	}
	if(
		Other.IsA('TFemale2Bot')
		&& Other.class!=class'EnhancedMH.EMHTFemale2Bot'
	)
	{
		ReplaceWith( Other, "EnhancedMH.EMHTFemale2Bot" );
	} */

	// Show panel on top of monsterend
	/* if ( Other.IsA('MonsterEnd') )
	{
			Pa = Spawn(class'EMHPanel',,,other.location+vect(+5,0,0),class'EMHPanel'.default.rotation);

			if( Pa == none )
				log("Unable to spawn MonsterEnd Panel !",'EnhancedMH');
	} */

	bSuperRelevant = 0;
	return true;
}

// Change player health
function ModifyPlayer(Pawn Other)
{
    if( Other != none )
    {
        if( bRegenHealth )
        {
            Other.ClientMessage("Liandri Corp. medical nanite have been injected in your body.");
            Other.ClientMessage("Your health will increase by"@left(string(PlusHealth/Timerrate),Instr( string(PlusHealth/Timerrate),".")+2)@"unit up to"@RegenHealthLimit);

            if( RegenHealthLimit > 100 )
                // Change max health of player if limit above 100
                Other.Health = RegenHealthLimit;
        }

        if( bRegenAmmo )
        {
            Other.ClientMessage("Micro factory have been add to your weapons.");
            Other.ClientMessage("Your ammo will increase by"@left(string(PlusAmmo/Timerrate),Instr( string(PlusAmmo/Timerrate),".")+2)@"unit to the weapon maximum.");
        }

    }

	if ( NextMutator != None )
            // Call ModifyPlayer of next mutator
            NextMutator.ModifyPlayer(Other);
}

simulated function Timer()
{
	local Pawn P;
	local int i;
	local bool bIsExcludedAmmo, bAmmoChange, bMessage;
	// local SkaarjTrooper ST;
	local PlayerPawn PP;

    if( bSurpriseAttack )
    {
        AttackCounter += 0.5;

        if( AttackCounter > AttackInterval )
        {
            SurpriseAttack();
            AttackCounter = 0;
        }
    }

    if( bEarthQuake )
    {
        QuakeCounter += 0.5;

        if( QuakeCounter == QuakeInterval )
        {
            GreenMessage("EarthQuake!");
            log("EarthQuake!",'EnhancedMH');
            QuakeCounter = 0 - Duration;
            RemainingTime = Duration;
        }

        if( RemainingTime > 0 )
        {
            EarthQuake();
        }

    }

    // Regen Health
    if( bRegenHealth )
    {
        RegenHealth();
    }

    // Regen Ammo
    if( bRegenAmmo )
    {
        RegenAmmo();
    }

	/* // Swap Skaarj Trooper unreal weapon to UT weapon
	// Look for source of DMMutator
	if( bChangeTrooperWeapon == True)
	{
		foreach AllActors( class 'SkaarjTrooper', ST)
		{
            if(UnrealWeapontoUT( ST.WeaponType ) != '')
            {
                ST.GiveWeapon(class<UnrealWeapontoUT(ST,ST.WeaponType)>);
            }
		}
	} */
}

function GiveWeapon( Pawn PlayerPawn, string aClassname )
{
	local class<Weapon> WeaponClass;
	local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		// newWeapon.bCanThrow = False; // In a team game player must share weapon
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		PlayerPawn.PendingWeapon = None;

		// Set weapon ammo percent
		if ( !newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator') )
		{
			newWeapon.GiveAmmo(PlayerPawn);
			if( NewWeaponAmmoPercent > 1)
			{
				NewWeaponAmmoPercent = 1;
				log("NewWeaponAmmoPercent > 1. Reset to 1",'EnhancedMH');
			}
			newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo/NewWeaponAmmoPercent;
		}
	}
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	// BIGIZMH002 fix for monster that attack other monster.
	// Also modify EAttitude of Monster?
	if ( Victim.isa('ScriptedPawn') && Instigatedby.isa('ScriptedPawn') )
		ActualDamage = 0;

	if ( InstigatedBy.bIsPlayer )
	{
		InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
	}

	//call the next mutator
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

/* Custom function */

function RegenHealth()
{
    local Pawn P;
    local int PlayerID;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P.IsA('Bot')  || P.IsA('TournamentPlayer') )
		{
			if (P.Health > 0) // Player is alive
			{
	            PlayerID = P.PlayerReplicationInfo.PlayerID; // Fetch PlayerID

                if ( P.Health < RegenHealthLimit )
                {
                    AddHealth[PlayerID] += PlusHealth;
					P.Health = FMin( RegenHealthLimit, P.Health+floor(AddHealth[PlayerID]) );
					AddHealth[PlayerID] -= floor(AddHealth[PlayerID]);
                }
			}
		}
	}
}

// Modify to accept percent of weapon max ammo
function RegenAmmo()
{
    local Pawn P;
    local int PlayerID;
    local Inventory Inv;
    local bool bIsExcludedAmmo;
    local int i;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if ( P.IsA('Bot')  || P.IsA('TournamentPlayer') )
		{
			if (P.Health > 0) // Player is alive
			{
	            PlayerID = P.PlayerReplicationInfo.PlayerID; // Fetch PlayerID
				AddAmmo[PlayerID] += PlusAmmo;

                bAmmoChange = false;

                for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
				{
                    if (
                        !(bExcludeRedeemer && Inv.IsA('WarHeadAmmo'))
                        && Ammo(Inv) != none
                        && P.bFire==0
                        && P.bAltFire==0
                    )
                    {
                        if ( Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo )
                        {
                            if( !bExcludeOtherWeapon )
                            {
                                Ammo(Inv).AmmoAmount += Floor(AddAmmo[PlayerID]);
                                bAmmoChange = True;
                            }
                            else
                            {
                                bIsExcludedAmmo = false;

                                // Test to see if ammo is in ExcludeAmmo
                                for(i=0;
                                    i<ArrayCount(ExcludeAmmo)
                                    && ExcludeAmmo[i] != ''
                                    && bIsExcludedAmmo == false
                                ;i++)
                                {
								    if( Inv.IsA(ExcludeAmmo[i]) )
								        bIsExcludedAmmo = True;
                                }

                                // Regen ammo if not excluded
                                if( !bIsExcludedAmmo )
                                {
                                    Ammo(Inv).AmmoAmount += Floor(AddAmmo[PlayerID]);
                                    bAmmoChange = True;
                                }
                            }
                        }
                        // Check that Ammoammount is not higher than Maxammo
                        if (Ammo(Inv).AmmoAmount > Ammo(Inv).MaxAmmo)
                        {
                            Ammo(Inv).AmmoAmount = Ammo(Inv).MaxAmmo;
                            AddAmmo[PlayerID] = 0;
                        }
                    }
                }

                if( bAmmoChange == true )
                    AddAmmo[PlayerID] -= Floor(AddAmmo[PlayerID]);
            }
		}
	}
}

function GreenMessage( string Message )
{
    local Pawn P;
    local color Green;

    // Set green color
    Green.G = 255;
    Green.B = 128;

    for ( P=Level.PawnList; P!=None; P=P.NextPawn )
    {
        if ( P.IsA('TournamentPlayer') )
        {
            PlayerPawn(P).SetProgressColor(Green, 0);
            PlayerPawn(P).SetProgressTime(3);
            PlayerPawn(P).SetProgressMessage(Message,0);
        }
    }
}

function SurpriseAttack()
{
/*	local int i, RandomPlayerID[32];
	local Pawn P;
	local Pawn Victim[32];
	local vector VictimVector[32];
	local bool MonsterResult;

    log(Level.Game.Numplayers);

    for( i=0; i < 32; i++ )
    {
        RandomPlayerID[i] = SelectPlayer( "Random" );
    }

    for ( P=Level.PawnList; P!=None ; P=P.NextPawn )
    {
        if ( P.IsA('TournamentPlayer') || P.IsA('Bot') )
        {
            if( P.PlayerReplicationInfo.PlayerID == RandomPlayerID[i] )
            {
                if (P.Health > 0) // Player is alive
                {
                    VictimVector[i]=P.location+P.CollisionHeight*4*vect(0,0,1);

                    MonsterResult = SpawnAttackMonster(class'UnrealI.SkaarjAssassin',VictimVector[i]+vect(0,60,0));
                    if( MonsterResult == false )
                        log("Monster Spawn fail!",'EnhancedMH');
                    MonsterResult = SpawnAttackMonster(class'UnrealI.SkaarjAssassin',VictimVector[i]+vect(0,-60,0));
                    if( MonsterResult == false )
                        log("Monster Spawn fail!",'EnhancedMH');
                }
            }
        }
    }*/
}

// Spawn monster for surprise attack
/* function bool SpawnAttackMonster( class<ScriptedPawn> SP, vector aVector )
{
    local ScriptedPawn AttackMonster;

    AttackMonster = Spawn(SP,,,aVector,);

    if( AttackMonster == none )
        return false;
    else
    {
        Level.Game.PlayTeleportEffect(AttackMonster,True,True);
        AttackMonster.SetPhysics(PHYS_Falling);
    }
} */

// Code from EarthQuake keypoint
function EarthQuake()
{
/*
    local Pawn P, P1;
    local PlayerPawn PP;
	local vector throwVect;
	local Actor A;
	local int RandomSound;

	throwVect = 0.15 * Magnitude * VRand();
	throwVect.Z = FMax(Abs(ThrowVect.Z), 120);

    P = Level.PawnList;
	while ( P != none )
    {
            if( P.IsA('PlayerPawn') )
            {
                P.BaseEyeHeight = FMin(P.Default.BaseEyeHeight, P.BaseEyeHeight * (0.5 + FRand()));
                P.ShakeView(duration, magnitude, 0.015 * magnitude);
                RandomSound = rand(1);
                if( RandomSound == 1 )
                    P.PlaySound(Sound'AmbOutside.OneShot.Quake32',,3.0,True,,0.25);
                else
                {
                    P.PlaySound(Sound'AmbOutside.OneShot.Quake33',,3.0,True,,0.25);
                }

                P1=P;

                foreach VisibleActors(class'Pawn', P1, radius)
                {
                    if (
                        ( P1.IsA('Pawn') && !P.IsA('PlayerPawn'))
                        && P1.Physics != PHYS_Falling
                    )
                        P1.AddVelocity(throwVect);
                    /* else if ( A.IsA('Decoration') && Decoration(A).bPushable
                        && (A.Physics == PHYS_None) )
                    {
                        A.SetPhysics(PHYS_Falling);
                        A.Velocity = throwVect;
                    }*/
                }
            }
        P = P.nextPawn;
    }
    RemainingTime -= 0.5;
*/
}

function int SelectPlayer( string Attribute )
{
	local int TempHealth;
	local int PlayerID;
	local Pawn P;

	if( Attribute == "Random" )
		return rand(Level.Game.NumPlayers-1); // PlayerID start from 0

	if( Attribute == "MinHealth" )
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		{
			if ( P.IsA('Bot')  || P.IsA('TournamentPlayer'))
			{
				if( P.Health < TempHealth || TempHealth == 0 )
				{
					PlayerID = P.PlayerReplicationInfo.PlayerID;
					TempHealth = P.Health;
				}
			}
		}

		return PlayerID;
	}

	if( Attribute == "MaxHealth" )
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		{
			if ( P.IsA('Bot')  || P.IsA('TournamentPlayer'))
			{
				if( P.Health > TempHealth )
				{
					PlayerID = P.PlayerReplicationInfo.PlayerID;
					TempHealth = P.Health;
				}
			}
		}

		return PlayerID;
	}
}

function UnrealWeapontoUT(string WeaponName)
{
    /* switch( WeaponName )
    {
        case 'dispersionpistol':
            return 'botpack.enforcer';
            break;
        case 'automag':
            return 'botpack.enforcer';
            break;
        case 'stinger':
            return 'botpack.pulsegun';
            break;
        case 'asmd':
            return 'botpack.shockrifle';
            break;
        case 'eightball':
            return 'botpack.ut_eightball';
            break;
        case 'flakcannon':
            return 'botpack.ut_flakcannon';
            break;
        case 'gesbiorifle':
            return 'botpack.UT_biorifle';
            break;
        case 'rifle':
            return 'botpack.sniperrifle';
            break;
        case 'minigun':
            return 'botpack.minigun2';
            break;
        default :
            return '';
    }*/
}

static function float floor(float x)
{
	local int WholePart;

	WholePart = x;

	if ( x >= 0 )
		return WholePart;
	else
		return WholePart - 1;
}

static function float ceiling(float x)
{
	local int WholePart;

	WholePart = x;

	if ( x >= 0 )
		return WholePart + 1;
	else
		return WholePart;
}

static function int SignOf(float Number)
{
    if( Number < 0 )
        return -1;
    else
    {
        return 1;
    }
}

function SwapInt( out int aInteger1, out int aInteger2 )
{
    local int Temp;

    Temp = aInteger1;
    aInteger1 = aInteger2;
    aInteger2 = Temp;
}

defaultproperties
{
	Version="0.2"
	TimerRate=0.5
	bRegenHealth=True
	bRegenAmmo=True
	PlusHealth=0.5
	PlusAmmo=0.2
	RegenHealthLimit=60
	bExcludeRedeemer=True
	bExcludeOtherWeapon=True
	ExcludeWeapon[0]='rlammo'
	RespawnTime=3
	NewWeaponAmmoPercent=0.10
	bSurpriseAttack=False
	AttackInterval=50
	bEarthQuake=False
	QuakeInterval=300
    Magnitude=2000
    Duration=10
    Radius=1000.000000
    bThrowPlayer=True
}
