/******************************************************************************
A Trigger that plays the *BeepSound* at the trigger location or for the
instigator only when triggered.
Additional 4 more *Messages* can be send with a time delay. Within this time
the Trigger does not receive Events and touching is ignored.

SeriousBarbie AT barbies DOT world

Changelog:
2016-09-29
+Initial release
2025-07-18
+ added *Messages* and *MessageDelays*
+ added *bBeepOnEveryMessage*
+ new Texture
* changed default RetriggerDelay from 0 to 2
* changed default BeepSound from NONE to Sound'UnrealShare.Pickups.TransA3'
******************************************************************************/

class SBBeepTrigger extends Trigger;

#exec TEXTURE IMPORT NAME=SBBeepTrigger FILE=Textures\SBBeepTrigger.pcx MIPS=OFF FLAGS=2

var(BeepSound) sound BeepSound;
var(BeepSound) byte BeepSoundVolume;
var(BeepSound) byte BeepSoundRadius;
var(BeepSound) byte BeepSoundPitch; // Sound pitch shift, 64.0=none.
var(BeepSound) bool bPlayForInstigatorOnly;
var(BeepSound) bool bBeepOnEveryMessage;

var(Trigger) string Messages[4];
var(Trigger) float MessageDelays[4];

var bool bBeepSoundNoOverride;
var byte i;// Internal counter
var PlayerPawn Toucher;
var name NextState;
var bool bHaveMultiMessages;
var bool bHaveMultiMessagesChecked;


event DoBeep(PlayerPawn Listener) {
	if (BeepSound != None)
		if (bPlayForInstigatorOnly && Listener != None)
			Listener.ClientPlaySound(BeepSound, true, true);
		else
			PlaySound(BeepSound, SLOT_Interact, BeepSoundVolume / 128, bBeepSoundNoOverride, BeepSoundRadius * 25, BeepSoundPitch / 64);

}



event DoMessage(PlayerPawn Toucher, string AMessage, bool bDoBeep) {
	Toucher.ClientMessage(AMessage);
	if (bDoBeep)
		DoBeep(Toucher);
}



function Bool HaveMultiMessages(){
	if (bHaveMultiMessagesChecked)
		return bHaveMultiMessages;
	else
	{
		for (i = 0; i < ArrayCount(Messages); i++)
			if (Messages[i] != "")
			{
				bHaveMultiMessages = true;
				break;
			}
		bHaveMultiMessagesChecked = true;
	}
}



function Touch(actor Other) {
	if (IsRelevant(Other))
	{
		if (ReTriggerDelay > 0)
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
		}
		Toucher = PlayerPawn(Other);
		DoBeep(Toucher);
		if (Toucher != None)
		{
			if (HaveMultiMessages())
			{
				if (Message != "") // stock message field
					DoMessage(Toucher, Message, false); // we have already beeped
				NextState = InitialState;
				GotoState('MultiMessages');
			}
		}
	}
	Super.Touch(Other); // will show *Message* when we don't have ane *Messages*
}



state MultiMessages {
	ignores Touch,Trigger;

begin:
	for (i = 0; i < ArrayCount(Messages); i++)
	{
		if (MessageDelays[i] > 0)
			Sleep(MessageDelays[i]);
		if (Messages[i] != "" && Toucher != None)
			DoMessage(Toucher, Messages[i], bPlayForInstigatorOnly && bBeepOnEveryMessage);
	}
	GotoState(NextState);
}



defaultproperties {
	BeepSound=Sound'UnrealShare.Pickups.TransA3'
	BeepSoundRadius=16
	BeepSoundVolume=128
	BeepSoundPitch=64
	bBeepSoundNoOverride=false
	bBeepOnEveryMessage=false
	bPlayForInstigatorOnly=false
	RetriggerDelay=2
	Texture=Texture'SBBeepTrigger'
}
