//-----------------------------------------------------------
//
//-----------------------------------------------------------
class UTUIFrontEnd_VASUT3VolatileAmmo extends UTUIFrontEnd;

var class<VASUT3VolatileAmmo> MutatorClass;
var transient UTUISlider VolatileAmmoCount;
var transient UTUISlider VolatileAmmoHealth;
var transient UTUISlider VolatileAmmoDamage;


event SceneActivated(bool bInitialActivation)
{
Super.SceneActivated(bInitialActivation);

if (bInitialActivation)
   {
   VolatileAmmoCount = UTUISlider(FindChild('VolatileAmmoCount', true));
   VolatileAmmoHealth = UTUISlider(FindChild('VolatileAmmoHealth', true));
   VolatileAmmoDamage = UTUISlider(FindChild('VolatileAmmoDamage', true));

   SetRangeData(VolatileAmmoCount, 5, 50, MutatorClass.default.VolatileAmmoCount, 5, true);
   SetRangeData(VolatileAmmoHealth, 0, 300, MutatorClass.default.VolatileAmmoHealth, 10, true);
   SetRangeData(VolatileAmmoDamage, 0, 100, MutatorClass.default.VolatileAmmoDamage, 1, true);
   }
}

function SetRangeData(UISlider Slider, float MinValue, float MaxValue, float CurrentValue, float NudgeValue, bool bIntRange)
{
	Slider.SliderValue.MinValue = MinValue;
	Slider.SliderValue.MaxValue = MaxValue;
	Slider.SliderValue.CurrentValue = CurrentValue;
	Slider.SliderValue.NudgeValue = NudgeValue;
	Slider.SliderValue.bIntRange = bIntRange;
	Slider.NotifyValueChanged();
}

function SetupButtonBar()
{
	ButtonBar.Clear();
	ButtonBar.AppendButton("<Strings:UTGameUI.ButtonCallouts.Back>", OnButtonBar_Back);
	ButtonBar.AppendButton("<Strings:UTGameUI.ButtonCallouts.Accept>", OnButtonBar_Accept);
}

function bool OnButtonBar_Back(UIScreenObject InButton, int InPlayerIndex)
{
	CloseScene(self);
	return true;
}

function SetTitle()
{
	local UILabel TitleLabel;
	local UTUIDataStore_MenuItems MenuDataStore;
	local int MutatorIndex;
	local string MutatorName;

	TitleLabel = GetTitleLabel();
	if(TitleLabel != none)
	{
		if(TabControl == none)
		{
			MenuDataStore = UTUIDataStore_MenuItems(class'UIInteraction'.static.GetDataStoreClient().FindDataStore('UTMenuItems'));
			MutatorIndex = MenuDataStore.FindValueInProviderSet('Mutators', 'ClassName', PathName(MutatorClass));
			if(MutatorIndex != INDEX_NONE)
   			  MenuDataStore.GetValueFromProviderSet('Mutators', 'FriendlyName', MutatorIndex, MutatorName);
		}
		TitleLabel.SetDataStoreBinding(MutatorName);
	}
}

function bool OnButtonBar_Accept(UIScreenObject InButton, int InPlayerIndex)
{
    MutatorClass.default.VolatileAmmoCount = VolatileAmmoCount.GetValue();
    MutatorClass.default.VolatileAmmoHealth = VolatileAmmoHealth.GetValue();
    MutatorClass.default.VolatileAmmoDamage = VolatileAmmoDamage.GetValue();
    MutatorClass.static.StaticSaveConfig();

	CloseScene(self);
	return true;
}


DefaultProperties
{
   MutatorClass = class'VASUT3VolatileAmmo.VASUT3VolatileAmmo'
   Name="Default__UTUIFrontEnd_VASUT3VolatileAmmo"
}