/* 
    UT3Fixer Copyright (C) 2008 Nico de Vries.

    This file is part of UT3Fixer.

    UT3Fixer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class UT3FixerPlayerController extends UTPlayerController;

var float countdown;
var bool reconnect;

function NotifyConnectionError (string Message, optional string Title)
{
  if (!reconnect) {
    reconnect = true;
    countdown = 3;
  }
}

event PlayerTick( float DeltaTime )
{
  Super.PlayerTick(DeltaTime);
  if (reconnect) {
    countdown -= DeltaTime;
    if (countdown <= 0) {
      reconnect = false;
      ConsoleCommand("Reconnect");
    }
  }
}

defaultproperties
{
}