/* 
    UT3Fixer Copyright (C) 2008 Nico de Vries.

    This file is part of UT3Fixer.

    UT3Fixer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class UT3FixerPlayerController extends UTPlayerController config (UT3Fixer);
// class UT3FixerPlayerController extends BattleRPG.BattlePlayerController config (UT3Fixer);
// class UT3FixerPlayerController extends BattleTeamArena.BattlePlayerController config (UT3Fixer);

var config int ClientTimeOutInSeconds;
var float StartTime;

replication
{
  if (Role == ROLE_Authority)
    ClientTimeOutInSeconds;
}

simulated function PostBeginPlay()
{
  if (ClientTimeOutInSeconds < 1) {
    ClientTimeOutInSeconds = 120; // Two minutes
    SaveConfig();
  }
  Super.PostBeginPlay();  
}

// Ignore connection errors for ClientTimeOutInSeconds seconds to compensate for bUseSeamlessTravel being false.
function NotifyConnectionError (string Message, optional string Title)
{
  if (StartTime < 1) StartTime = WorldInfo.TimeSeconds;
  if (WorldInfo.TimeSeconds - StartTime > ClientTimeOutInSeconds) {
    Super.NotifyConnectionError (Message, Title);
  }
}

defaultproperties
{
}