//============================================================
// TTeamFixRules.uc	- Class for managing GameRule specific events
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
Class TTeamFixRules extends GameRules;

var TTeamFix Master;

var bool bPreSpawnEvent;
var bool bKillEvent;
var bool bRestartGameEvent;
var bool bDamageEvent;

var bool bWithinPlayerKilled;


function InitializeEvents(TTeamFix Caller)
{
	// Some checking statements
	if (Caller == none)
	{
		WarnInternal("TTeamFixRules::InitializeEvents Caller is none");
		return;
	}

	if (Master != none && Master != Caller)
		WarnInternal("TTeamFixRules::InitializeEvents Master was already set, initializing from new Caller and disregarding old Master");

	Master = Caller;

	bPreSpawnEvent = Master.bNeedPreSpawnEvent;
	bKillEvent = Master.bNeedKilledEvent;
	bRestartGameEvent = Master.bNeedRestartGameEvent;
	bDamageEvent = Master.bNeedDamageEvent;
}

function NavigationPoint FindPlayerStart(Controller Player, optional byte InTeam, optional string incomingName)
{
	if (bPreSpawnEvent && Master != none && Player != none)
		Master.PlayerSpawning(Player, InTeam);

	return Super.FindPlayerStart(Player, InTeam, incomingName);
}

function ScoreKill(Controller Killer, Controller Killed)
{
	if (bKillEvent && !bWithinPlayerKilled && Master != none && Killed != none)
	{
		bWithinPlayerKilled = True;
		Master.PlayerKilled(Killed);
		bWithinPlayerKilled = False;
	}

	Super.ScoreKill(Killer, Killed);
}

function bool HandleRestartGame()
{
	if (bRestartGameEvent && Master != none)
		Master.NotifyRestartGame();

	return Super.HandleRestartGame();
}

function NetDamage(int OriginalDamage, out int Damage, pawn Injured, Controller InstigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
	Super.NetDamage(OriginalDamage, Damage, Injured, InstigatedBy, HitLocation, Momentum, DamageType);

	if (bDamageEvent && Master != none)
		Master.NotifyPlayerDamaged(Damage, Injured, InstigatedBy);
}

