//============================================================
// TTeamFixPersistentData.uc	- An object for temporarily storing persistent data between levels
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// This class is used by the team shuffling code, when
// ShuffleTeams is set to ST_MatchStart and ShuffleMode is set
// to anything other than SM_Random
//
// In these circumstances, information about the damage dealt
// and player score etc. needs to be brought over between
// levels
//
//============================================================
Class TTeamFixPersistentData extends Object
	config(TitanTeamFix)
	perobjectconfig;


struct TTFPlayerData
{
	var UniqueNetID UID;
	var string GUID;
	var string IP;

	var int Score;
	var int Deaths;
	var int DamageDealt;
	var int DamageTaken;
	var int PlayTime;
	var int ELORank;
};

var globalconfig array<TTFPlayerData> StoredPlayerData;

// Runtime variables
var TTeamFixPersistentData CachedObj;

var array<PlayerController> AssociatedControllers;

var deprecated bool bTODO;


static final function TTeamFixPersistentData GetPersistentDataObj()
{
	local TTeamFixPersistentData TempCachedObj;

	if (default.CachedObj == none)
	{
		TempCachedObj = new(none, "PersistentData") default.Class;
		TTeamFixPersistentData(FindObject(default.Class.GetPackageName()$".Default__"$string(default.Class), default.Class)).CachedObj = TempCachedObj;
	}

	return default.CachedObj;
}

function StorePlayerData(TTeamFix Owner, optional bool bTemporaryData)
{
	local TTeamFixGeneric TTFG;
	local PlayerController PC;
	local int i, j, Len;
	local TTFPlayerData SD;
	local UniqueNetID NullID;

	TTFG = TTeamFixGeneric(Owner);
	StoredPlayerData.Length = 0;
	AssociatedControllers.Length = 0;

	if (TTFG != none)
	{
		// First grab the Controller/PRI related player info
		foreach Owner.WorldInfo.AllControllers(Class'PlayerController', PC)
		{
			if (PC.PlayerReplicationInfo == none || PC.PlayerReplicationInfo.bOnlySpectator)
				continue;


			i = StoredPlayerData.Length;
			StoredPlayerData.Length = i+1;
			AssociatedControllers.Length = i+1;

			AssociatedControllers[i] = PC;

			StoredPlayerData[i].UID = PC.PlayerReplicationInfo.UniqueID;
			StoredPlayerData[i].GUID = PC.HashResponseCache;
			StoredPlayerData[i].IP = PC.GetPlayerNetworkAddress();

			j = InStr(StoredPlayerData[i].IP, ":");

			if (j != INDEX_None)
				StoredPlayerData[i].IP = Left(StoredPlayerData[i].IP, j);

			// ***
			bTODO = True;
			// Remove this debug code

			if (StoredPlayerData[i].IP == "127.0.0.1")
				StoredPlayerData[i].GUID = PC.PlayerReplicationInfo.GetPlayerAlias();
			// ***


			// If no identifying information was stored, there is no point in adding this entry
			if (StoredPlayerData[i].UID == NullID && StoredPlayerData[i].IP == "" &&
				(StoredPlayerData[i].GUID == "" || StoredPlayerData[i].GUID == "0"))
			{
				StoredPlayerData.Length = i;
				continue;
			}


			StoredPlayerData[i].Score = PC.PlayerReplicationInfo.Score;
			StoredPlayerData[i].Deaths = PC.PlayerReplicationInfo.Deaths;
			StoredPlayerData[i].PlayTime = Owner.WorldInfo.GRI.ElapsedTime - PC.PlayerReplicationInfo.StartTime;
			StoredPlayerData[i].ELORank = PC.PlayerReplicationInfo.PlayerRanking;

			// TODO: Consider storing a filtered version of the player name
		}


		// Now the damage tracker data (if set)
		Len = TTFG.DamageTracker.Length;

		for (i=0; i<Len; ++i)
		{
			j = AssociatedControllers.Find(PlayerController(TTFG.DamageTracker[i].C));

			if (j != INDEX_None)
			{
				StoredPlayerData[j].DamageDealt = TTFG.DamageTracker[i].DamageDealt;
				StoredPlayerData[j].DamageTaken = TTFG.DamageTracker[i].DamageTaken;
			}
		}


		// ***
		bTODO = True;
		// Remove this debug code (only when online testing is complete)
		for (i=0; i<StoredPlayerData.Length; ++i)
		{
			SD = StoredPlayerData[i];
			`log("Storing player data (Index:"@i$"), UID:"@Class'OnlineSubsystem'.static.UniqueNetIDToString(SD.UID)$", GUID:"@SD.GUID
				$", IP:"@SD.IP$", Score:"@SD.Score$", Deaths:"@SD.Deaths$", DamageDealt:"@SD.DamageDealt
				$", DamageTaken:"@SD.DamageTaken$", PlayTime:"@SD.PlayTime$", ELORank:"@SD.ELORank,, 'TTFDebug');
		}
		// ***


		// NOTE: When 'bTemporaryData' is set, the code expects 'ClearPlayerData' to be called later!
		if (!bTemporaryData)
		{
			AssociatedControllers.Length = 0;
			SaveConfig();
		}
	}
}

// Removes invalid data and sets up the 'AssociatedControllers' list
function SetupPlayerData(TTeamFix Owner)
{
	local PlayerController PC;
	local UniqueNetID NullID;
	local int i, j;
	local string IP;

	if (StoredPlayerData.Length <= 0)
		return;


	AssociatedControllers.Length = 0;
	AssociatedControllers.Length = StoredPlayerData.Length;

	foreach Owner.WorldInfo.AllControllers(Class'PlayerController', PC)
	{
		if (PC.PlayerReplicationInfo == none || PC.PlayerReplicationInfo.bOnlySpectator)
			continue;


		// ***
		bTODO = True;
		// Remove this debug code

		if (Left(PC.GetPlayerNetworkAddress(), InStr(PC.GetPlayerNetworkAddress(), ":")) == "127.0.0.1")
			PC.HashResponseCache = PC.PlayerReplicationInfo.GetPlayerAlias();
		// ***

		i = INDEX_None;

		if (PC.PlayerReplicationInfo.UniqueID != NullID)
			i = StoredPlayerData.Find('UID', PC.PlayerReplicationInfo.UniqueID);

		if (i == INDEX_None && PC.HashResponseCache != "" && PC.HashResponseCache != "0")
			i = StoredPlayerData.Find('GUID', PC.HashResponseCache);

		if (i == INDEX_None)
		{
			IP = PC.GetPlayerNetworkAddress();

			j = InStr(IP, ":");

			if (j != INDEX_None)
				IP = Left(IP, j);

			if (IP != "")
				i = StoredPlayerData.Find('IP', IP);
		}


		if (i != INDEX_None)
			AssociatedControllers[i] = PC;
	}

	for (i=AssociatedControllers.Length-1; i>0; --i)
	{
		if (AssociatedControllers[i] == none)
		{
			StoredPlayerData.Remove(i, 1);
			AssociatedControllers.Remove(i, 1);
		}
	}
}

function ClearPlayerData()
{
	AssociatedControllers.Length = 0;
	ClearConfig();
}
