//============================================================
// TTeamFixMutSettings.uc	- Class for giving webadmin access to basic TitanTeamFix settings
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
Class TTeamFixMutSettings extends Settings;

enum EPropertyRenderType
{
	RT_Normal,
	RT_Color
};

var array<string> PropertyDescriptions;
var array<EPropertyRenderType> PropertyRenderTypes;

var byte MessagePropertiesStart, MessagePropertiesEnd, MessageDefaultsStart, MessageDefaultsEnd;

function SetSpecialValue(name PropertyName, string NewValue)
{
	local bool bOldWebAdminOption, bOldMessagesDisabled;
	local string CurProperty;
	local Actor ActorRef;
	local TTeamFix TTF;
	local TTeamFixConfigLoader TTFCL;
	local TTeamFixMessageReplicationInfo TTFMRI;
	local int i;

	// Cut down on assignment string sizes below (looks slightly less ugly)
	TTFCL = TTeamFixConfigLoader(FindObject(default.Class.GetPackageName()$".Default__TTeamFixConfigLoader", Class'TTeamFixConfigLoader'));

	TTFMRI = TTeamFixMessageReplicationInfo(FindObject(Class'TTeamFixMessageReplicationInfo'.GetPackageName()$
		".Default__TTeamFixMessageReplicationInfo", Class'TTeamFixMessageReplicationInfo'));


	if (PropertyName == 'WebAdmin_Init')
	{
		// TTeamFixConfigLoader settings
		CurProperty = string(int(TTFCL.bAddWebAdminConfigMenu));
		SetPropertyFromStringByName('bAddWebAdminConfigMenu', CurProperty);

		CurProperty = TTFCL.ActiveConfigurationProfile;
		SetPropertyFromStringByName('ActiveConfigurationProfile', CurProperty);

		CurProperty = string(int(TTFCL.bSuffixGameToProfile));
		SetPropertyFromStringByName('bSuffixGameToProfile', CurProperty);


		// TTeamFixMessageReplicationInfo settings
		CurProperty = string(int(TTFMRI.bEnableCustomMessages));
		SetPropertyFromStringByName('bEnableCustomMessages', CurProperty);

		// Temporarily enable the message config property ID's (to set the default values)
		for (i=MessagePropertiesStart; i<=MessagePropertiesEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, i);

		for (i=MessageDefaultsStart; i<=MessageDefaultsEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, i);


		CurProperty = ColorToHTMLColor(TTFMRI.MessageColour);
		SetPropertyFromStringByName('MessageColour', CurProperty);

		CurProperty = TTFMRI.SwitchedMessage;
		SetPropertyFromStringByName('SwitchedMessage', CurProperty);

		CurProperty = TTFMRI.AnnounceMessage;
		SetPropertyFromStringByName('AnnounceMessage', CurProperty);

		CurProperty = TTFMRI.MultipleAnnounceMessage;
		SetPropertyFromStringByName('MultipleAnnounceMessage', CurProperty);

		CurProperty = TTFMRI.ImbalanceMessage;
		SetPropertyFromStringByName('ImbalanceMessage', CurProperty);

		CurProperty = TTFMRI.IdleImbalanceMessage;
		SetPropertyFromStringByName('IdleImbalanceMessage', CurProperty);

		CurProperty = TTFMRI.SlotOpenedMessage;
		SetPropertyFromStringByName('SlotOpenedMessage', CurProperty);

		CurProperty = TTFMRI.ShuffleMessage;
		SetPropertyFromStringByName('ShuffleMessage', CurProperty);


		// Default message properties
		SetDefaultMessageProperties();


		// Setup whether or not the message config properties should show (depending upon 'bEnableCustomMessages')
		for (i=MessagePropertiesStart; i<=MessagePropertiesEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, (TTFMRI.bEnableCustomMessages ? i : -1));

		for (i=MessageDefaultsStart; i<=MessageDefaultsEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, (TTFMRI.bEnableCustomMessages ? i : -1));
	}
	else if (PropertyName == 'WebAdmin_Save')
	{
		bOldWebAdminOption = TTFCL.bAddWebAdminConfigMenu;


		// TTeamFixConfigLoader settings
		CurProperty = GetPropertyAsStringByName('bAddWebAdminConfigMenu');
		TTFCL.bAddWebAdminConfigMenu = bool(CurProperty);

		TTFCL.ActiveConfigurationProfile = GetPropertyAsStringByName('ActiveConfigurationProfile');

		CurProperty = GetPropertyAsStringByName('bSuffixGameToProfile');
		TTFCL.bSuffixGameToProfile = bool(CurProperty);

		Class'TTeamFixConfigLoader'.static.StaticSaveConfig();


		// TTeamFixMessageReplicationInfo settings
		CurProperty = GetPropertyAsStringByName('bEnableCustomMessages');
		TTFMRI.bEnableCustomMessages = bool(CurProperty);

		bOldMessagesDisabled = !GetPropertyID('SwitchedMessage', i) || i == INDEX_None;

		// Setup whether or not the message config properties should show (depending upon 'bEnableCustomMessages')
		for (i=MessagePropertiesStart; i<=MessagePropertiesEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, (TTFMRI.bEnableCustomMessages ? i : -1));

		for (i=MessageDefaultsStart; i<=MessageDefaultsEnd; ++i)
			Class'UnrealScriptTools2.USTools2'.static.SetPropertyMappingElementID(PropertyMappings, i, (TTFMRI.bEnableCustomMessages ? i : -1));


		if (!bOldMessagesDisabled)
		{
			TTFMRI.MessageColour = HTMLColorToColor(GetPropertyAsStringByName('MessageColour'));

			TTFMRI.SwitchedMessage = GetPropertyAsStringByName('SwitchedMessage');
			TTFMRI.AnnounceMessage = GetPropertyAsStringByName('AnnounceMessage');
			TTFMRI.MultipleAnnounceMessage = GetPropertyAsStringByName('MultipleAnnounceMessage');
			TTFMRI.ImbalanceMessage = GetPropertyAsStringByName('ImbalanceMessage');
			TTFMRI.IdleImbalanceMessage = GetPropertyAsStringByName('IdleImbalanceMessage');
			TTFMRI.SlotOpenedMessage = GetPropertyAsStringByName('SlotOpenedMessage');
			TTFMRI.ShuffleMessage = GetPropertyAsStringByName('ShuffleMessage');
		}

		if (TTFMRI.bEnableCustomMessages)
			SetDefaultMessageProperties();


		// Get a reference to an actor so that we can use AllActors (HACK!! HACK!! HACK!! HACK!! HACK!! HACK!! HACK!!)
		ActorRef = Actor(FindObject("Engine.Default__Actor", Class'Actor'));

		foreach ActorRef.AllActors(Class'TTeamFixMessageReplicationInfo', TTFMRI)
		{
			TTFMRI.ReloadDefaults(True, True);
		}

		Class'TTeamFixMessageReplicationInfo'.static.StaticSaveConfig();


		if (TTFCL.bAddWebAdminConfigMenu && !bOldWebAdminOption)
		{
			foreach ActorRef.AllActors(Class'TTeamFix', TTF)
			{
				if (TTF.WebAdminHookClass == none)
					TTF.InitializeWebAdminHook();
			}
		}
	}
}

function string GetSpecialValue(name PropertyName)
{
	local int i;
	local string GroupStr;

	// If custom messages are enabled, group the custom message strings into a separate tab
	if (PropertyName == 'WebAdmin_Groups' && Class'TTeamFixMessageReplicationInfo'.default.bEnableCustomMessages)
	{
		GetPropertyID('bEnableCustomMessages', i);
		GroupStr = "Main Settings=0,"$i+1$";";

		GroupStr $= "Custom Messages="$MessagePropertiesStart$","$(MessagePropertiesEnd+1)$";";
		GroupStr $= "Default Messages="$MessageDefaultsStart$","$(MessageDefaultsEnd+1)$";";


		return GroupStr;
	}

	i = PropertyMappings.Find('Name', PropertyName);

	if (i != INDEX_None && PropertyDescriptions.Length > i)
		return PropertyDescriptions[i];


	return "";
}

// Must only be called when the default messages PropertyMappings 'ID' value is set
function SetDefaultMessageProperties()
{
	local TTeamFixMessages TTFM;
	local string CurProperty;

	TTFM = TTeamFixMessages(FindObject(Class'TTeamFixMessages'.GetPackageName()$".Default__TTeamFixMessages", Class'TTeamFixMessages'));

	CurProperty = ColorToHTMLColor(TTFM.DrawColor);
	SetPropertyFromStringByName('DefaultMessageColour', CurProperty);

	CurProperty = TTFM.SwitchedMessage;
	SetPropertyFromStringByName('DefaultSwitchedMessage', CurProperty);

	CurProperty = TTFM.AnnounceMessage;
	SetPropertyFromStringByName('DefaultAnnounceMessage', CurProperty);

	CurProperty = TTFM.MultipleAnnounceMessage;
	SetPropertyFromStringByName('DefaultMultipleAnnounceMessage', CurProperty);

	CurProperty = TTFM.ImbalanceMessage;
	SetPropertyFromStringByName('DefaultImbalanceMessage', CurProperty);

	CurProperty = TTFM.IdleImbalanceMessage;
	SetPropertyFromStringByName('DefaultIdleImbalanceMessage', CurProperty);

	CurProperty = TTFM.SlotOpenedMessage;
	SetPropertyFromStringByName('DefaultSlotOpenedMessage', CurProperty);

	CurProperty = TTFM.ShuffleMessage;
	SetPropertyFromStringByName('DefaultShuffleMessage', CurProperty);
}


// From WebAdmin source
static final function String ColorToHTMLColor(color clr)
{
	return "#"$Right(ToHex(clr.R), 2)$Right(ToHex(clr.G), 2)$Right(ToHex(clr.B), 2);
}

// Not from WebAdmin source
static final function Color HTMLColorToColor(string HTMLColor, optional byte ForceAlpha=255)
{
	local int i;
	local Color ReturnVal;

	i = InStr(HTMLColor, "#");

	if (i == INDEX_None)
		return ReturnVal;

	HTMLColor = Caps(HTMLColor);


	// Parse the red part of the HTMLColor
	i = Asc(Mid(HTMLColor, 1, 1));
	ReturnVal.R = (i < 58 ? (i-48) : (i-55)) * 16;

	i = Asc(Mid(HTMLColor, 2, 1));
	ReturnVal.R += (i < 58 ? (i-48) : (i-55));

	// Green
	i = Asc(Mid(HTMLColor, 3, 1));
	ReturnVal.G = (i < 58 ? (i-48) : (i-55)) * 16;

	i = Asc(Mid(HTMLColor, 4, 1));
	ReturnVal.G += (i < 58 ? (i-48) : (i-55));

	// Blue
	i = Asc(Mid(HTMLColor, 5, 1));
	ReturnVal.B = (i < 58 ? (i-48) : (i-55)) * 16;

	i = Asc(Mid(HTMLColor, 6, 1));
	ReturnVal.B += (i < 58 ? (i-48) : (i-55));


	ReturnVal.A = ForceAlpha;


	return ReturnVal;
}


defaultproperties
{
	Properties(0)=(PropertyID=0,Data=(Type=SDT_Int32))
	Properties(1)=(PropertyID=1,Data=(Type=SDT_String))
	Properties(2)=(PropertyID=2,Data=(Type=SDT_Int32))
	Properties(3)=(PropertyID=3,Data=(Type=SDT_Int32))
	Properties(4)=(PropertyID=4,Data=(Type=SDT_String))
	Properties(5)=(PropertyID=5,Data=(Type=SDT_String))
	Properties(6)=(PropertyID=6,Data=(Type=SDT_String))
	Properties(7)=(PropertyID=7,Data=(Type=SDT_String))
	Properties(8)=(PropertyID=8,Data=(Type=SDT_String))
	Properties(9)=(PropertyID=9,Data=(Type=SDT_String))
	Properties(10)=(PropertyID=10,Data=(Type=SDT_String))
	Properties(11)=(PropertyID=11,Data=(Type=SDT_String))
	Properties(12)=(PropertyID=12,Data=(Type=SDT_String))
	Properties(13)=(PropertyID=13,Data=(Type=SDT_String))
	Properties(14)=(PropertyID=14,Data=(Type=SDT_String))
	Properties(15)=(PropertyID=15,Data=(Type=SDT_String))
	Properties(16)=(PropertyID=16,Data=(Type=SDT_String))
	Properties(17)=(PropertyID=17,Data=(Type=SDT_String))
	Properties(18)=(PropertyID=18,Data=(Type=SDT_String))
	Properties(19)=(PropertyID=19,Data=(Type=SDT_String))


	PropertyMappings(0)=(ID=0,Name="bAddWebAdminConfigMenu",ColumnHeaderText="Add Titan Team Fix WebAdmin Menu",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(1)=(ID=1,Name="ActiveConfigurationProfile",ColumnHeaderText="Active Configuration Profile")
	PropertyMappings(2)=(ID=2,Name="bSuffixGameToProfile",ColumnHeaderText="Add Game To Profile Name",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(3)=(ID=3,Name="bEnableCustomMessages",ColumnHeaderText="Customize Messages",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	MessagePropertiesStart=4
	PropertyMappings(4)=(ID=-1,Name="MessageColour",ColumnHeaderText="Message Colour")
	PropertyMappings(5)=(ID=-1,Name="SwitchedMessage",ColumnHeaderText="Switched Message")
	PropertyMappings(6)=(ID=-1,Name="AnnounceMessage",ColumnHeaderText="Announce Switch Message")
	PropertyMappings(7)=(ID=-1,Name="MultipleAnnounceMessage",ColumnHeaderText="Announce Multiple Switch Message")
	PropertyMappings(8)=(ID=-1,Name="ImbalanceMessage",ColumnHeaderText="Imbalance Message")
	PropertyMappings(9)=(ID=-1,Name="IdleImbalanceMessage",ColumnHeaderText="Imbalance and Idle Message")
	PropertyMappings(10)=(ID=-1,Name="SlotOpenedMessage",ColumnHeaderText="Player Slot Opened Message")
	PropertyMappings(11)=(ID=-1,Name="ShuffleMessage",ColumnHeaderText="Team Shuffle Message")
	MessagePropertiesEnd=11
	MessageDefaultsStart=12
	PropertyMappings(12)=(ID=-1,Name="DefaultMessageColour",ColumnHeaderText="Message Colour")
	PropertyMappings(13)=(ID=-1,Name="DefaultSwitchedMessage",ColumnHeaderText="Switched Message")
	PropertyMappings(14)=(ID=-1,Name="DefaultAnnounceMessage",ColumnHeaderText="Announce Switch Message")
	PropertyMappings(15)=(ID=-1,Name="DefaultMultipleAnnounceMessage",ColumnHeaderText="Announce Multiple Switch Message")
	PropertyMappings(16)=(ID=-1,Name="DefaultImbalanceMessage",ColumnHeaderText="Imbalance Message")
	PropertyMappings(17)=(ID=-1,Name="DefaultIdleImbalanceMessage",ColumnHeaderText="Imbalance and Idle Message")
	PropertyMappings(18)=(ID=-1,Name="DefaultSlotOpenedMessage",ColumnHeaderText="Player Slot Opened Message")
	PropertyMappings(19)=(ID=-1,Name="DefaultShuffleMessage",ColumnHeaderText="Team Shuffle Message")
	MessageDefaultsEnd=19

	PropertyRenderTypes(0)=RT_Normal
	PropertyRenderTypes(1)=RT_Normal
	PropertyRenderTypes(2)=RT_Normal
	PropertyRenderTypes(3)=RT_Normal
	PropertyRenderTypes(4)=RT_Color
	PropertyRenderTypes(5)=RT_Normal
	PropertyRenderTypes(6)=RT_Normal
	PropertyRenderTypes(7)=RT_Normal
	PropertyRenderTypes(8)=RT_Normal
	PropertyRenderTypes(9)=RT_Normal
	PropertyRenderTypes(10)=RT_Normal
	PropertyRenderTypes(11)=RT_Normal
	PropertyRenderTypes(12)=RT_Color
	PropertyRenderTypes(13)=RT_Normal
	PropertyRenderTypes(14)=RT_Normal
	PropertyRenderTypes(15)=RT_Normal
	PropertyRenderTypes(16)=RT_Normal
	PropertyRenderTypes(17)=RT_Normal
	PropertyRenderTypes(18)=RT_Normal
	PropertyRenderTypes(19)=RT_Normal

	PropertyDescriptions(0)="Whether or not to add a 'Titan Team Fix' selection to the WebAdmin menu (i.e. this page)"
	PropertyDescriptions(1)="The name of the configuration profile (or set of configuration profiles) which Titan Team Fix should load"
	PropertyDescriptions(2)="Whether or not to append the currently running gametype to 'Active Configuration Profile', e.g: 'Default' may become 'Default_UTCTFGame_Content'"
	PropertyDescriptions(3)="Allows customization of the messages displayed to clients"
	PropertyDescriptions(4)="The colour given to all messages"
	PropertyDescriptions(5)="The message given to a player, when switched to the other team"
	PropertyDescriptions(6)="The message given to ALL players, when a player is switched (the code %p is replaced with the player name at runtime)"
	PropertyDescriptions(7)="The same as 'Announce Switch Message', but for multiple players being switched"
	PropertyDescriptions(8)="The message given to all players, when the teams become uneven"
	PropertyDescriptions(9)="Same as 'Imbalance Message', except this includes the number of idle players (the code %i is replaced with the number of idle players)"
	PropertyDescriptions(10)="The message given to spectators on a full server, when an active player leaves (thus opening a slot for a spectator to join)"
	PropertyDescriptions(11)="The mesage given to all players, when the teams are shuffled at the start/end of game"
	PropertyDescriptions(12)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(13)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(14)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(15)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(16)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(17)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(18)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
	PropertyDescriptions(19)="Contains the default value for the same property on the 'Custom Messages' tab (in case you want to reset values)"
}

