//============================================================
// TTeamFixLite.uc	- A team balancer based off of the generic balancer, but which doesn't use the mutator module
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// A more limited version of the generic balancer class,
// which can be run without removing the servers 'pure' status
//
//============================================================
Class TTeamFixLite extends TTeamFixGeneric;

function PostBeginPlay()
{
	Super.PostBeginPlay();

	// Enable the timer after one tick; allows the TTeamFixMut class to block initialization, and initialize a different balancer
	if (WorldInfo.GetMapName() != "EnvyEntry")
		SetTimer(0.1,, 'EnableBalancer');
}


function EnableBalancer()
{
	if (bBlockInitialization)
	{
		`log("Initialization of 'Lite' balancer has been blocked (possibly to replace with different balancer), destroying",, 'TitanTeamFix');
		Destroy();

		return;
	}

	if (UTTeamGame(WorldInfo.Game) != none && WorldInfo.GetMapName() != "EnvyEntry")
	{
		InitializeBalancing();
		SetTimer(Max(30, BalanceCountdown+10), True, 'CheckForImbalance');
	}
}

function InitializeDefaults()
{
	if (bBotsBalanceTeams)
		bNeedPreSpawnEvent = True;

	bNeedKilledEvent = True;
	bNeedRestartGameEvent = True;

	if (PreferredTeams != PT_Enable)
	{
		`log("The 'PreferredTeams' option does not work with the TitanTeamFix 'Lite' balancer",, 'TitanTeamFix');
		PreferredTeams = PT_Enable;
	}

	if (bAnnounceSlotOpened)
	{
		`log("The 'bAnnounceSlotOpened' option does not work with the TitanTeamFix 'Lite' balancer",, 'TitanTeamFix');
		bAnnounceSlotOpened = False;
	}

	Super.InitializeDefaults();
}

// Overrides all 'bNeedxx' variables relating to the mutator module
function bool NeedMutator()
{
	return False;
}


function NotifyRestartGame()
{
	ResetBalancing();
}


function PlayerSpawning(controller Player, out byte InTeam)
{
	// ***
	bTODO = True;
	// Implement 'bBotsBalanceTeams' check here (and here only)
	// NOTE: Do this after moving the 'bBotsBalanceTeam' checks to their own function, in the generic class
	// ***

	Super.PlayerSpawning(Player, InTeam);
}

function PlayerKilled(Controller Player)
{
	CheckForImbalance();

	Super.PlayerKilled(Player);
}

