//============================================================
// TTeamFixConfigLoader.uc	- Used for loading multiple configuration profiles from the same server install
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// This class allows a serveradmin to specify what config
// preset he wants TitanTeamFix to load.
// This allows an admin to run multiple servers from the same
// UT installation whilst allowing each server to use a
// completely different TitanTeamFix configuration
//
//============================================================
Class TTeamFixConfigLoader extends Object
	config(Game);

var config string ActiveConfigurationProfile;
var config bool bSuffixGameToProfile;		// If true, it suffixes the profile name with the current GameInfo's class name (excluding package name)
var config bool bAddWebAdminConfigMenu;

var array<TTeamFixConfigProfile> CachedConfigProfiles;


// A static accessor for loading and caching config profile references (FindObject wont work in this case, as this must not return subclasses of 'ProfileClass')
static final function TTeamFixConfigProfile FindConfigProfile(coerce string ProfileName, Class<TTeamFixConfigProfile> ProfileClass)
{
	local int i;
	local TTeamFixConfigLoader DefaultSelf;
	local TTeamFixConfigProfile NewProfile;

	for (i=0; i<default.CachedConfigProfiles.Length; ++i)
	{
		if (string(default.CachedConfigProfiles[i].Name) ~= ProfileName && default.CachedConfigProfiles[i].Class == ProfileClass)
			return default.CachedConfigProfiles[i];
	}


	// Get a reference to this classes default object, and statically store the new config profile object
	DefaultSelf = TTeamFixConfigLoader(FindObject(default.Class.GetPackageName()$".Default__"$string(default.Class), default.Class));
	NewProfile = new(none, ProfileName) ProfileClass;

	DefaultSelf.CachedConfigProfiles.Length = i;
	DefaultSelf.CachedConfigProfiles[i] = NewProfile;


	return NewProfile;
}

defaultproperties
{
	ActiveConfigurationProfile="default"
	bSuffixGameToProfile=True
	bAddWebAdminConfigMenu=True
}