//============================================================
// TTFProfile_Generic.uc	- An object for storing multiple configuration profiles
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// This profile class is only compatable with the 
// TTeamFixGeneric balancing class.
//
//============================================================
class TTFProfile_Generic extends TTeamFixConfigProfile
	dependson(TTeamFix);

var databinding config TTeamFixGeneric.EImbalanceAction	ImbalanceAction;
var databinding config int				BalanceCountdown;
var databinding config bool				bAnnounceSwitch;
var databinding config bool				bAnnounceImbalance;
var databinding config bool				bAnnounceSlotOpened;
var databinding config TTeamFixGeneric.EPreferredTeams	PreferredTeams;
var databinding config TTeamFixGeneric.EShuffleTeams	ShuffleTeams;
var databinding config TTeamFixGeneric.EShuffleMode	ShuffleMode;
var databinding config bool				bBotsBalanceTeams;
var databinding config int				BotBalanceCutoff;
var databinding config bool				bIgnoreIdlePlayers;
var databinding config int				IgnoreIdleTime;
var databinding config int				RecentlyJoinedTime;
var config array<SwitchOrderElement>			SwitchOrder;	// TODO: Try to make this compatible with the webadmin at some stage



function CopyFromProfile(TTeamFix Owner)
{
	local TTeamFixGeneric TTFG;

	TTFG = TTeamFixGeneric(Owner);

	TTFG.ImbalanceAction		= ImbalanceAction;
	TTFG.BalanceCountdown		= BalanceCountdown;
	TTFG.bAnnounceSwitch		= bAnnounceSwitch;
	TTFG.bAnnounceImbalance		= bAnnounceImbalance;
	TTFG.bAnnounceSlotOpened	= bAnnounceSlotOpened;
	TTFG.PreferredTeams		= PreferredTeams;
	TTFG.ShuffleTeams		= ShuffleTeams;
	TTFG.ShuffleMode		= ShuffleMode;
	TTFG.bBotsBalanceTeams		= bBotsBalanceTeams;
	TTFG.BotBalanceCutoff		= BotBalanceCutoff;
	TTFG.bIgnoreIdlePlayers		= bIgnoreIdlePlayers;
	TTFG.IgnoreIdleTime		= IgnoreIdleTime;
	TTFG.RecentCutoffTime		= RecentlyJoinedTime;
	TTFG.SwitchOrder		= SwitchOrder;
}

function CopyToProfile(TTeamFix Owner)
{
	local TTeamFixGeneric TTFG;

	TTFG = TTeamFixGeneric(Owner);

	ImbalanceAction		= TTFG.ImbalanceAction;
	BalanceCountdown	= TTFG.BalanceCountdown;
	bAnnounceSwitch		= TTFG.bAnnounceSwitch;
	bAnnounceImbalance	= TTFG.bAnnounceImbalance;
	bAnnounceSlotOpened	= TTFG.bAnnounceSlotOpened;
	PreferredTeams		= TTFG.PreferredTeams;
	ShuffleTeams		= TTFG.ShuffleTeams;
	ShuffleMode		= TTFG.ShuffleMode;
	bBotsBalanceTeams	= TTFG.bBotsBalanceTeams;
	BotBalanceCutoff	= TTFG.BotBalanceCutoff;
	bIgnoreIdlePlayers	= TTFG.bIgnoreIdlePlayers;
	IgnoreIdleTime		= TTFG.IgnoreIdleTime;
	RecentlyJoinedTime	= TTFG.RecentCutofftime;
	SwitchOrder		= TTFG.SwitchOrder;
}

function ValidateProperties(optional TTeamFix Owner)
{
	bIgnoreIdlePlayers = (bIgnoreIdlePlayers && IgnoreIdleTime > 0 &&
		(Owner == none || IgnoreIdleTime < Owner.WorldInfo.Game.MaxIdleTime || Owner.WorldInfo.Game.MaxIdleTime <= 0));

	// BotBalanceCutoff should always be an even number
	if ((BotBalanceCutoff % 2) != 0)
		BotBalanceCutoff++;

	// Make sure it doesn't surpass the maxplayer count
	if (Owner != none && BotBalanceCutoff > Owner.WorldInfo.Game.MaxPlayers)
		BotBalanceCutOff = ((Owner.WorldInfo.Game.MaxPlayers % 2) == 0 ? Owner.WorldInfo.Game.MaxPlayers : Owner.WorldInfo.Game.MaxPlayers-1);

	// Minumum value of 30 for this, to stop it breaking things
	if (RecentlyJoinedTime < 30)
		RecentlyJoinedTime = 30;
}


function SaveWebAdminProperties(TTeamFix Owner, out string Warning, out string Error)
{
	Super.SaveWebAdminProperties(Owner, Warning, Error);

	if (TTeamFixLite(Owner) != none)
		Warning = "NOTE: The Titan Team Fix 'Lite' balancer does not support the following settings: Preferred Teams, Announce Slot Opened";
}


defaultproperties
{
	BalancerClass=Class'TTeamFixGeneric'
	WebAdminHookClass="TTFWebAdmin.TTFWebAdminHook_Generic"

	// NOTE: If you update a default property here, make sure you do it in ALL OTHER TTFProfile_Generic subclasses (if any) too!

	ImbalanceAction=IA_CountdownOrDeath
	BalanceCountdown=15
	PreferredTeams=PT_PreferLosingTeam
	bAnnounceSwitch=True
	bAnnounceImbalance=True
	bAnnounceSlotOpened=True
	ShuffleTeams=ST_MatchStart
	ShuffleMode=SM_DamageDealtPerSecond
	bBotsBalanceTeams=False
	BotBalanceCutoff=0
	bIgnoreIdlePlayers=False
	IgnoreIdleTime=0
	RecentlyJoinedTime=120
	SwitchOrder(0)=(Variable=SV_SwitchCount,Placement=SP_Low)
	SwitchOrder(1)=(Variable=SV_FlagDistance,Placement=SP_Low)
	SwitchOrder(2)=(Variable=SV_JoinTime,Placement=SP_Low)
	SwitchOrder(3)=(Variable=SV_InVehicle,Placement=SP_Low)
	SwitchOrder(4)=(Variable=SV_HasSuperPickup,Placement=SP_Low)


	Properties(0)=(PropertyID=0,Data=(Type=SDT_Int32))
	Properties(1)=(PropertyID=1,Data=(Type=SDT_Int32))
	Properties(2)=(PropertyID=2,Data=(Type=SDT_Int32))
	Properties(3)=(PropertyID=3,Data=(Type=SDT_Int32))
	Properties(4)=(PropertyID=4,Data=(Type=SDT_Int32))
	Properties(5)=(PropertyID=5,Data=(Type=SDT_Int32))
	Properties(6)=(PropertyID=6,Data=(Type=SDT_Int32))
	Properties(7)=(PropertyID=7,Data=(Type=SDT_Int32))
	Properties(8)=(PropertyID=8,Data=(Type=SDT_Int32))
	Properties(9)=(PropertyID=9,Data=(Type=SDT_Int32))
	Properties(10)=(PropertyID=10,Data=(Type=SDT_Int32))
	Properties(11)=(PropertyID=11,Data=(Type=SDT_Int32))
	Properties(12)=(PropertyID=12,Data=(Type=SDT_Int32))

	PropertyMappings(0)=(ID=0,Name="ImbalanceAction",ColumnHeaderText="Imbalance Action",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No Action"),(ID=1,Name="Balance after Countdown"),(ID=2,Name="Balance on Death"),(ID=3,Name="Countdown or Death"),(ID=4,Name="Balance on Team Death")))
	PropertyMappings(1)=(ID=1,Name="BalanceCountdown",ColumnHeaderText="Balance Countdown",MappingType=PVMT_Ranged,MaxVal=120.000000,RangeIncrement=5.000000)
	PropertyMappings(2)=(ID=2,Name="PreferredTeams",ColumnHeaderText="Preferred Teams",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="Disable"),(ID=1,Name="Enable (UT default)"),(ID=2,Name="Prefer Losing Team")))
	PropertyMappings(3)=(ID=3,Name="bAnnounceSwitch",ColumnHeaderText="Announce Switches",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(4)=(ID=4,Name="bAnnounceImbalance",ColumnHeaderText="Announce Team Imbalance",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(5)=(ID=5,Name="bAnnounceSlotOpened",ColumnHeaderText="Announce Slot Opened",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(6)=(ID=6,Name="ShuffleTeams",ColumnHeaderText="Shuffle Teams",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="Disable"),(ID=1,Name="At Start of Match"),(ID=2,Name="At End of Match")))
	PropertyMappings(7)=(ID=7,Name="ShuffleMode",ColumnHeaderText="Shuffle Ranking Method",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="Random"),(ID=1,Name="Points"),(ID=2,Name="Points Vs Deaths"),(ID=3,Name="Points Per Second"),(ID=4,Name="Damage Dealt"),(ID=5,Name="Damage Dealt Vs Damage Taken"),(ID=6,Name="Damage Dealt Per Second"),(ID=7,Name="ELO Rank")))
	PropertyMappings(8)=(ID=8,Name="bBotsBalanceTeams",ColumnHeaderText="Bots Balance Teams",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(9)=(ID=9,Name="BotBalanceCutoff",ColumnHeaderText="Bot Balance Cutoff",MappingType=PVMT_Ranged,MaxVal=32.000000,RangeIncrement=1.000000)
	PropertyMappings(10)=(ID=10,Name="bIgnoreIdlePlayers",ColumnHeaderText="Ignore Idle Players",MappingType=PVMT_IDMapped,ValueMappings=((ID=0,Name="No"),(ID=1,Name="Yes")))
	PropertyMappings(11)=(ID=11,Name="IgnoreIdleTime",ColumnHeaderText="Ignore Idle Time",MappingType=PVMT_Ranged,MaxVal=9999.000000,RangeIncrement=10.000000)
	PropertyMappings(12)=(Id=12,Name="RecentlyJoinedTime",ColumnHeaderText="Recently Joined Time",MappingType=PVMT_Ranged,MaxVal=9999.000000,RangeIncrement=10.000000)

	PropertyDescriptions(0)="The action Titan Team Fix will take when the teams become uneven"
	PropertyDescriptions(1)="The number of seconds Titan Team Fix will count down from, before balancing the teams (only applies to 'Countdown' and 'Countdown or Death')"
	PropertyDescriptions(2)="How to handle joining players preferred team selection"
	PropertyDescriptions(3)="Whether or not to announce forced team switches"
	PropertyDescriptions(4)="Whether or not to make an announcement when the teams become uneven"
	PropertyDescriptions(5)="Whether or not to make an announcement to spectators, when a player slot opens"
	PropertyDescriptions(6)="When to shuffle/randomize the teams (if at all)"
	PropertyDescriptions(7)="The method used to rate and balance players when shuffling teams"
	PropertyDescriptions(8)="Whether or not bots should be added to balance the teams"
	PropertyDescriptions(9)="Once the human playercount reaches this number, bots are no longer added to balance the teams (when that setting is enabled)"
	PropertyDescriptions(10)="Whether or not to count idle players, when checking if the teams are uneven (if bKickLiveIdlers is false, then the idle timer does not start until the player dies)"
	PropertyDescriptions(11)="The amount of time a player can be inactive, before Titan Team Fix considers that player as idle (if MaxIdleTime is set, this must be less than that)"
	PropertyDescriptions(12)="The amount of time since joining where a player is considered 'recently joined' (only these players are switched when 'Imbalance Action' is 'Balance on Death')"
}
