//============================================================
// TTeamFixSettingsRenderer.uc	- A modified version of the WebAdmin settings renderer, specifically for TTF config profiles
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// Slightly haxxed version of the WebAdmin settings renderer
//
//============================================================
Class TTeamFixSettingsRenderer extends SettingsRenderer;

function string renderGroup(SettingsGroup group)
{
	local TTeamFixConfigProfile CP;
	local TTeamFixMutSettings MS;
	local string result, entry, desc;
	local int i, j;
	local EPropertyValueMappingType mtype;

	CP = TTeamFixConfigProfile(curSettings);
	MS = TTeamFixMutSettings(curSettings);

	for (i = 0; i < group.settings.length; i++)
	{
		if (group.settings[i].isLocalized)
		{
			entry = renderLocalizedSetting(curSettings.LocalizedSettingsMappings[group.settings[i].idx].Id);
		}
		else {
			j = group.settings[i].idx;

			curSettings.GetPropertyMappingType(curSettings.PropertyMappings[j].Id, mtype);
			defaultSubst(curSettings.PropertyMappings[j].Id);
			switch (mtype)
			{
				case PVMT_PredefinedValues:
					entry = renderPredefinedValues(curSettings.PropertyMappings[j].Id, j);
					break;
				case PVMT_Ranged:
					entry = renderRanged(curSettings.PropertyMappings[j].Id);
					break;
				case PVMT_IdMapped:
					entry = renderIdMapped(curSettings.PropertyMappings[j].Id, j);
					break;
				default:
					if (MS != none && MS.PropertyRenderTypes[j] != RT_Normal)
						entry = RenderSpecial(CurSettings.PropertyMappings[j].ID, j, MS.PropertyRenderTypes[j]);
					else
						entry = renderRaw(curSettings.PropertyMappings[j].Id, j);
			}

			if (CP != none)
				desc = CP.PropertyDescriptions[j];
			else if (MS != none)
				desc = MS.GetSpecialValue(curSettings.PropertyMappings[j].Name);
		}
		if (len(entry) > 0)
		{
			curResponse.subst("setting.html", entry);
			curResponse.subst("setting.description", desc);
			result $= curResponse.LoadParsedUHTM(path $ "/TitanTeamFix_Settings_Entry.inc");
		}
	}
	return result;
}


function string RenderSpecial(int ID, int Index, EPropertyRenderType RenderType)
{
	CurResponse.Subst("setting.type", string(GetEnum(Enum'EPropertyRenderType', RenderType)));
	CurResponse.Subst("setting.value", CurSettings.GetPropertyAsString(ID));

	if (RenderType == RT_Color)
		return CurResponse.LoadParsedUHTM(path$"/TitanTeamFix_Settings_Color.inc");

	return "";
}


