//============================================================
// TTeamFixQueryHandler.uc	- Query handler base class for TitanTeamFix
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
Class TTeamFixQueryHandler extends Object;
	//implements(IQueryHandler);

var TTeamFix TeamBalancer;


static final function bool IsAlphaNumeric(const out string S, optional string IgnoredChars)
{
	local int i, j, ChrLen;

	ChrLen = Len(S);

	for (i=0; i<ChrLen; ++i)
	{
		j = Asc(Mid(S, i, 1));

		if ((j < 48 || (j > 57 && j < 65) || (j > 90 && j < 97) || j > 122) && InStr(IgnoredChars, Chr(j)) == INDEX_None)
			return False;
	}


	return True;
}

