//============================================================
// TTFWebAdminHook_Base.uc	- A base class for 'hooking' into the UT3 webadmin, by adding a query handler
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// The sole purpose of this class is basically to add a query handler to the UT3 webadmin
//
//============================================================
Class TTFWebAdminHook_Base extends TTeamFixWebAdminHook;

var Class<TTeamFixQueryHandler> QueryHandlerClass;

static function InitializeWebAdminHook(TTeamFix Owner, object WebServerObj)
{
	local WebServer WS;
	local int i;
	local WebAdmin WA;
	local TTeamFixQueryHandler QH;

	if (default.QueryHandlerClass == none)
		return;


	WS = WebServer(WebServerObj);

	if (WS != none)
	{
		for (i=0; i<ArrayCount(WS.ApplicationObjects); ++i)
		{
			if (WebAdmin(WS.ApplicationObjects[i]) != none)
			{
				WA = WebAdmin(WS.ApplicationObjects[i]);
				break;
			}
		}

		// Add the query handler
		if (WA != none)
		{
			QH = new(WA) default.QueryHandlerClass;
			QH.TeamBalancer = Owner;

			WA.AddQueryHandler(QH);
		}
	}
}