//============================================================
// TTeamFixMessageReplicationInfo.uc	- Allows the server to set custom notification messages for clients
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
//
// This class implements server overriding of the default TTF
// messages
//
//============================================================
Class TTeamFixMessageReplicationInfo extends ReplicationInfo
	config(TitanTeamFix);


// Whether or not to enable custom messages from the server
var config bool bEnableCustomMessages;
var config bool bClientEnableCustomMessages;

// Overridden message values (serverside only)
var config string SwitchedMessage;
var config string AnnounceMessage;
var config string MultipleAnnounceMessage;
var config string ImbalanceMessage;
var config string SlotOpenedMessage;
var config string ShuffleMessage;
var config string IdleImbalanceMessage;

var config color MessageColour;


// Replicated variables (repnotify may be a bit inefficient, but will do as replication will most often only occur at spawn)
var repnotify string SwitchedMsg;
var repnotify string AnnounceMsg;
var repnotify string MultiAnnounceMsg;
var repnotify string ImbalanceMsg;
var repnotify string SlotOpenedMsg;
var repnotify string ShuffleMsg;
var repnotify string IdleImbalanceMsg;

var repnotify color MsgColour;


// Runtime variables
var bool bForceMessagesUpdate; // If you want to change messages more than once at runtime, use this


replication
{
	if (bNetInitial || (bNetDirty && bForceMessagesUpdate))
		SwitchedMsg, AnnounceMsg, MultiAnnounceMsg, ImbalanceMsg, SlotOpenedMsg, ShuffleMsg, IdleImbalanceMsg, MsgColour;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();


	// Make sure the TTF local message class has defaults setup
	if (WorldInfo.NetMode != NM_DedicatedServer)
		Class'TTeamFixMessages'.static.SetupMessages();

	if (WorldInfo.NetMode != NM_Client && default.bEnableCustomMessages)
		ReloadDefaults();
}

function ReloadDefaults(optional bool bLocalDefaults, optional bool bForceUpdate)
{
	local bool bNeedUpdate;
	local TTeamFixMessages TTFM;
	local color DefaultColour;


	// Cut down on ugly looking checks..changes 'Class'TTeamFixMessages'.default.SwitchedMessage' to 'TTFM.SwitchedMessage'
	TTFM = TTeamFixMessages(FindObject(default.Class.GetPackageName()$".Default__TTeamFixMessages", Class'TTeamFixMessages'));


	if (bLocalDefaults)
	{
		SwitchedMessage = default.SwitchedMessage;
		AnnounceMessage = default.AnnounceMessage;
		MultipleAnnounceMessage = default.MultipleAnnounceMessage;
		ImbalanceMessage = default.ImbalanceMessage;
		SlotOpenedMessage = default.SlotOpenedMessage;
		ShuffleMessage = default.ShuffleMessage;
		IdleImbalanceMessage = default.IdleImbalanceMessage;
		MessageColour = default.MessageColour;
	}


	// Go through all messages, checking that the current value is not the default value (NOTE: " " is used to blank messages clientside)
	if (bLocalDefaults ? SwitchedMsg != SwitchedMessage : SwitchedMessage != TTFM.SwitchedMessage)
	{
		SwitchedMsg = (SwitchedMessage != "" ? SwitchedMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? AnnounceMsg != AnnounceMessage : AnnounceMessage != TTFM.AnnounceMessage)
	{
		AnnounceMsg = (AnnounceMessage != "" ? AnnounceMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? MultiAnnounceMsg != MultipleAnnounceMessage : MultipleAnnounceMessage != TTFM.MultipleAnnounceMessage)
	{
		MultiAnnounceMsg = (MultipleAnnounceMessage != "" ? MultipleAnnounceMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? ImbalanceMsg != ImbalanceMessage : ImbalanceMessage != TTFM.ImbalanceMessage)
	{
		ImbalanceMsg = (ImbalanceMessage != "" ? ImbalanceMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? SlotOpenedMsg != SlotOpenedMessage : SlotOpenedMessage != TTFM.SlotOpenedMessage)
	{
		SlotOpenedMsg = (SlotOpenedMessage != "" ? SlotOpenedMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? ShuffleMsg != ShuffleMessage : ShuffleMessage != TTFM.ShuffleMessage)
	{
		ShuffleMsg = (ShuffleMessage != "" ? ShuffleMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? IdleImbalanceMsg != IdleImbalanceMessage : IdleImbalanceMessage != TTFM.IdleImbalanceMessage)
	{
		IdleImbalanceMsg = (IdleImbalanceMessage != "" ? IdleImbalanceMessage : " ");
		bNeedUpdate = True;
	}

	if (bLocalDefaults ? (MsgColour != MessageColour && MsgColour != DefaultColour) : MessageColour != TTFM.DrawColor)
	{
		MsgColour = (MessageColour != DefaultColour ? MessageColour : MessageColour + MakeColor(1,0,0,0));
		bNeedUpdate = True;
	}


	if (bForceUpdate && bNeedUpdate)
		bForceMessagesUpdate = True;
}


simulated function ReplicatedEvent(name VarName)
{
	local TTeamFixMessages TTFM;

	if (WorldInfo.NetMode != NM_Client || !default.bClientEnableCustomMessages)
		return;


	TTFM = TTeamFixMessages(FindObject(default.Class.GetPackageName()$".Default__TTeamFixMessages", Class'TTeamFixMessages'));

	if (VarName == 'SwitchedMsg')
		TTFM.SwitchedMsg = (SwitchedMsg != " " ? SwitchedMsg : "");
	else if (VarName == 'AnnounceMsg')
		TTFM.AnnounceMsg = (AnnounceMsg != " " ? AnnounceMsg : "");
	else if (VarName == 'MultiAnnounceMsg')
		TTFM.MultiAnnounceMsg = (MultiAnnounceMsg != " " ? MultiAnnounceMsg : "");
	else if (VarName == 'ImbalanceMsg')
		TTFM.ImbalanceMsg = (ImbalanceMsg != " " ? ImbalanceMsg : "");
	else if (VarName == 'SlotOpenedMsg')
		TTFM.SlotOpenedMsg = (SlotOpenedMsg != " " ? SlotOpenedMsg : "");
	else if (VarName == 'ShuffleMsg')
		TTFM.ShuffleMsg = (ShuffleMsg != " " ? ShuffleMsg : "");
	else if (VarName == 'IdleImbalanceMsg')
		TTFM.IdleImbalanceMsg = (IdleImbalanceMsg != " " ? IdleImbalanceMsg : "");
	else if (VarName == 'MsgColour')
		TTFM.DrawColor = MsgColour;
	else
		Super.ReplicatedEvent(VarName);
}


defaultproperties
{
	bEnableCustomMessages=False
	bClientEnableCustomMessages=True

	SwitchedMessage="TitanTeamFix: You have been switched to balance the teams"
	AnnounceMessage="TitanTeamFix: %p has been switched to balance the teams"
	MultipleAnnounceMessage="TitanTeamFix: %p have been switched to balance the teams"
	ImbalanceMessage="TitanTeamFix: The teams have become uneven"
	SlotOpenedMessage="TitanTeamFix: A slot has opened, another player can join the game"
	ShuffleMessage="TitanTeamFix: The teams have been rebalanced"
	IdleImbalanceMessage="TitanTeamFix: The teams have become uneven (Idle Players: %i)"

	MessageColour=(R=145,G=135,B=181,A=255)
}



