//============================================================
// TTeamFixDebugFileWriter.uc	- A file writer class for outputting TTF debug information
//============================================================
//	TitanTeamFix
//		- A modular team balancing tool initially coded for the Titan servers:
//			http://ut2004.titaninternet.co.uk/
//
//	Copyright (C) 2007-2009 John "Shambler" Barrett (JBarrett847@Gmail.com or Shambler@OldUnreal.com)
//
//	This program is free software; you can redistribute and/or modify
//	it under the terms of the Open Unreal Mod License version 1.1.
//
//============================================================
Class TTeamFixDebugFileWriter extends FileWriter;

var bool bActive;
var int Indent;
var string IndentStr;

static final function TTeamFixDebugFileWriter GetDebugWriter(Actor ActorRef, string DataType, optional bool bTakeoverActiveWriters)
{
	local TTeamFixDebugFileWriter DFW;

	foreach ActorRef.AllActors(Class'TTeamFixDebugFileWriter', DFW)
	{
		if (!DFW.bActive || bTakeoverActiveWriters)
			break;
	}

	if (DFW == none)
		DFW = ActorRef.Spawn(Class'TTeamFixDebugFileWriter');
	else if (DFW.bActive)
		DFW.Close();

	DFW.Initialize(DataType);


	return DFW;
}

final function Initialize(string DataType)
{
	OpenFile("TTFDebug_"$DataType, FWFT_Debug, ".log",, True);
	ResetIndent();
	bActive = True;

	Logf("---FileStart---");
}

final function Close()
{
	Logf("---FileEnd---");

	bActive = False;
	CloseFile();
}


final function Log(coerce string Data)
{
	if (Indent > 0)
		Data = IndentStr$Data;

	Logf(Data);
}


final function IncreaseIndent(optional int Size=1)
{
	local int i;

	Indent += Size;

	for (i=0; i<Size; ++i)
		IndentStr $= "	";
}

final function DecreaseIndent(optional int Size=1)
{
	Indent = Max(0, Indent-Size);
	IndentStr = Left(IndentStr, Indent);
}

final function SetIndent(int Length)
{
	local int i;

	if (Length < Indent)
		IndentStr = Left(IndentStr, Length);
	else if (Length > Indent)
		for (i=Indent; i<Length; ++i)
			IndentStr $= "	";

	Indent = Length;
}

final function ResetIndent()
{
	Indent = 0;
	IndentStr = "";
}



