// Coded by Gugi
// Visit www.ut2k4-gaming.de!!
class MutSpamProtect extends UTMutator
   config(Game);

var config float RepeatLimitOther;
var config float RepeatLimitSame;
var config bool bActiveForAdmins;
var config bool AdvancedSpamDetect;
var config bool bEnabled;

var SpamBroadcastHandler SBH;

function InitMutator(string Options, out string ErrorMessage)
{
 if (WorldInfo.Game!=None)
 {
   SBH=Spawn(class'SpamBroadcastHandler');
   SBH.MSP=self;
   if(SBH!=None)
   {
     if (WorldInfo.Game.BroadcastHandler!=None)
       WorldInfo.Game.BroadcastHandler.Destroy();
     WorldInfo.Game.BroadcastHandler=SBH;
   }
 }
 Super.InitMutator(Options, ErrorMessage);
}

function NotifyLogout(Controller Exiting)
{
 local int i;
 if ( (SBH!=None) && (SBH.MutedPlayers.Length>0) )
 {
  while (i<SBH.MutedPlayers.Length)
  {
   if (SBH.MutedPlayers[i]==Exiting)
   {
    SBH.MutedPlayers.Remove(i, 1);
    break;
   }
   ++i;
  }
 }

 Super.NotifyLogout(Exiting);
}

function Mutate(string MutateString, PlayerController Sender)
{
 local string Temp;
 local int i;
 local PlayerController PC;

 Super.Mutate(MutateString, Sender);

 if ( (MutateString~="SpamInfo") && (Sender!=None) )
 {
  Sender.ClientMessage("------------------------------------------------------");
  Sender.ClientMessage("       Spam-Mutator--UT3 Version------Coded by Gugi");
  Sender.ClientMessage("This is a mutator, which trys to prevent spamming.");
  Sender.ClientMessage("Use 'mutate SpamHelp' for a list of availabel commands");
  Sender.ClientMessage("  while logged in as server-administrator.");
  Sender.ClientMessage("------------------------------------------------------");
 }

 if (Left(MutateString, 5)~="Spam " && (Sender!=None) && (Sender.PlayerReplicationInfo!=None) &&
     (Sender.PlayerReplicationInfo.bAdmin||WorldInfo.NetMode==NM_Standalone) && (MutateString!="") )
 {
  MutateString=Mid(MutateString, 5);
  if (MutateString~="Help")
  {
   Sender.ClientMessage("--------------------------------------------------------");
   Sender.ClientMessage("Spam-Mutator enabled:"@(bEnabled&&RepeatLimitOther>0));
   Sender.ClientMessage("Use 'mutate SpamHelp <command>' for a description of a command.");
   Sender.ClientMessage("Available Commands (put in a 'mutate Spam' at the beginning):");
   Sender.ClientMessage("   ToggleSpamMutEnabled      ShowSpamSettings");
   Sender.ClientMessage("   SetChatIntervall          SetSameMsgIntervall");
   Sender.ClientMessage("   ToggleActiveForAdmins     ToggleExtSpamCheck");
   Sender.ClientMessage("   MutePlayer                UnMutePlayer");
   Sender.ClientMessage("   SpamInfo");
  }
  else if (Left(MutateString, 5)~="Help ")
  {
   Temp=Mid(MutateString, 5);
   if (Temp~="SetChatIntervall")
     Sender.ClientMessage("Sets the time, before a player can chat again. Currently set to:"@RepeatLimitOther);
   else if (Temp~="SetSameMsgIntervall")
     Sender.ClientMessage("Sets the time, before a player can send the same message as before again. Currently set to:"@RepeatLimitSame);
   else if (Temp~="ToggleActiveForAdmins")
     Sender.ClientMessage("Enables/Disables the spam-check for admins. Currently active:"@bActiveForAdmins);
   else if (Temp~="ToggleExtSpamCheck")
     Sender.ClientMessage("Enables/Disables the advanced spam-check. Currently active:"@AdvancedSpamDetect);
   else if (Temp~="ToggleSpamMutEnabled")
     Sender.ClientMessage("Enables/Disables the whole Spam-Mutator. Currently active:"@bEnabled);
   else if (Temp~="ShowSpamSettings")
     Sender.ClientMessage("Shows the current settings.");
   else if (Temp~="SpamInfo")
     Mutate("SpamInfo", Sender);
   else if (Temp~="MutePlayer")
     Sender.ClientMessage("Mutes a player.");
   else if (Temp~="UnMutePlayer")
     Sender.ClientMessage("Unmutes a player.");
  }
  else if (MutateString~="ToggleSpamMutEnabled")
  {
   bEnabled=!bEnabled;
   Sender.ClientMessage("Spam-Mutator is enabled:"@bEnabled);
   SaveConfig();
  }
  else if (Left(MutateString, 17)~="SetChatIntervall ")
  {
   RepeatLimitOther=FMax(float(Mid(MutateString, 17)), 0.0);
   Sender.ClientMessage("Time, before a player can chat again, has been set to:"@RepeatLimitOther);
   SaveConfig();
  }
  else if (Left(MutateString, 20)~="SetSameMsgIntervall ")
  {
   RepeatLimitSame=FMax(float(Mid(MutateString, 20)), 0.0);
   Sender.ClientMessage("Time, before a player can send the same message again, has been set to:"@RepeatLimitSame);
   SaveConfig();
  }
  else if (MutateString~="ToggleActiveForAdmins")
  {
   bActiveForAdmins=!bActiveForAdmins;
   Sender.ClientMessage("Spam-Check is active for admins:"@bActiveForAdmins);
   SaveConfig();
  }
  else if (MutateString~="ToggleExtSpamCheck")
  {
   AdvancedSpamDetect=!AdvancedSpamDetect;
   Sender.ClientMessage("Advanced spam-check is enabled:"@AdvancedSpamDetect);
   SaveConfig();
  }
  else if (MutateString~="ShowSpamSettings")
  {
   Sender.ClientMessage("Spam-Mutator is enabled:"@bEnabled);
   Sender.ClientMessage("Time, before a player can chat again:"@RepeatLimitOther);
   Sender.ClientMessage("Time, before a player can send the same message as before again:"@RepeatLimitSame);
   Sender.ClientMessage("Spam-Check will also be preformed on admins:"@bActiveForAdmins);
   Sender.ClientMessage("Advanced spam-check is enabled:"@AdvancedSpamDetect);
   if (SBH!=None)
   {
    for (i=0;i<SBH.MutedPlayers.Length;i++)
      Sender.ClientMessage("MutedPlayer"@i$":"@SBH.MutedPlayers[i].PlayerReplicationInfo.PlayerName);
   }
  }
  else if (Left(MutateString, 11)~="MutePlayer ")
  {
   if (SBH==None)
   {
    Sender.ClientMessage("Cant mute player. Internal Error!");
    return;
   }
   
   PC=GetPlayerByName(Mid(MutateString, 11));
   if (PC==None)
   {
     Sender.ClientMessage("Player \""$Mid(MutateString, 13)$"\"not found.");
     return;
   }
   for (i=0;i<SBH.MutedPlayers.Length;i++)
   {
     if (SBH.MutedPlayers[i]==PC)
     {
       Sender.ClientMessage("Player \""$Mid(MutateString, 13)$"\" is already muted!");
       return;
     }
   }
   
   SBH.MutedPlayers[SBH.MutedPlayers.Length]=PC;
   Sender.ClientMessage("Muted"@PC.PlayerReplicationInfo.PlayerName$".");
  }
  else if (Left(MutateString, 13)~="UnMutePlayer ")
  {
   if (SBH==None)
   {
    Sender.ClientMessage("Cant unmute player. Internal Error!");
    return;
   }
   
   PC=GetPlayerByName(Mid(MutateString, 13));

   for (i=0;i<SBH.MutedPlayers.Length;i++)
   {
    if (SBH.MutedPlayers[i]==PC)
    {
     Sender.ClientMessage("Unmuted"@SBH.MutedPlayers[i].PlayerReplicationInfo.PlayerName$".");
     SBH.MutedPlayers.Remove(i, 1);
    }
   }
  }
 }
}

function PlayerController GetPlayerByName(string PlName)
{
 local int i;
 if (PlName~="")
   return None;
 // Check if the name perfectly matches
 for(i=0;i<WorldInfo.GRI.PRIArray.Length;++i)
 {
  if (WorldInfo.GRI.PRIArray[i]!=None)
  {
   if (WorldInfo.GRI.PRIArray[i].PlayerName~=PlName)
     return PlayerController(WorldInfo.GRI.PRIArray[i].Owner);
  }
 }
 // if no, the check with InStr
 for(i=0;i<WorldInfo.GRI.PRIArray.Length;++i)
 {
  if (WorldInfo.GRI.PRIArray[i]!=None)
  {
   if (InStr(Caps(WorldInfo.GRI.PRIArray[i].PlayerName), Caps(PlName))!=-1)
     return PlayerController(WorldInfo.GRI.PRIArray[i].Owner);
  }
 }
 return None;
}

defaultproperties
{
   GroupNames(0)="SpamProtection"
   Name="UTMutator_SpamProtect"
}
