class UTItem_HealthPack extends UTInventory;

var int HealAmount;
var bool bSuperHeal;

replication
{
	if ((Role == ROLE_Authority) && bNetDirty)
    		HealAmount;
}

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	super.GivenTo(NewOwner, bDoNotActivate);

	if (UTPawn(NewOwner) != None)
    {
        if (bSuperHeal)
        {
            UTPawn(NewOwner).GiveHealth(HealAmount, UTPawn(NewOwner).SuperHealthMax);
        }
        else
        {
            UTPawn(NewOwner).GiveHealth(HealAmount, UTPawn(NewOwner).HealthMax);
        }
    }
    Destroy(); // Destroy Item After Given To Player To Allow Players To Pickup Multiple Health Items.
}

defaultproperties
{
	PickupMessage="Health Pack"
	ItemName="Health Pack"
	HealAmount=20
	Begin Object Class=StaticMeshComponent Name=MeshComponentA ObjName=MeshComponentA Archetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
      StaticMesh=StaticMesh'PICKUPS.Health_Medium.Mesh.S_Pickups_Health_Medium'
      CullDistance=7000.000000
      CachedCullDistance=4500.000000
      bUseAsOccluder=False
      CastShadow=False
      bForceDirectLightMap=True
      bCastDynamicShadow=False
      CollideActors=False
      BlockActors=False
      BlockRigidBody=False
   End Object
   DroppedPickupMesh=MeshComponentA
}