class UTItem_ArmorShieldBelt extends UTItem_Armor;

var class<UTDroppedItemPickup> ShieldBeltPickupClass;

/** AddShieldStrength()
add shield to appropriate P armor type.
*/
function AddShieldStrength(UTPawn P)
{
	local MaterialInterface ShieldMat;

	// Get the proper shield material
	ShieldMat = P.GetShieldMaterialInstance(WorldInfo.Game.bTeamGame);

	// Assign it
	P.ShieldBeltArmor = Max(ShieldAmount, P.ShieldBeltArmor);
	P.ShieldBeltPickupClass = ShieldBeltPickupClass;
	if (P.GetOverlayMaterial() == None)
	{
		P.SetOverlayMaterial(ShieldMat);
	}
}

defaultproperties
{
	ShieldAmount=100
    PickupMessage="Shield Belt"
	ItemName="Shield Belt"
	Begin Object Name=MeshComponentA ObjName=MeshComponentA Archetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
      StaticMesh=StaticMesh'PICKUPS.Armor_ShieldBelt.Mesh.S_UN_Pickups_Shield_Belt'
      Scale3D=(X=1.500000,Y=1.500000,Z=1.500000)
   End Object
   ShieldBeltPickupClass=Class'UTGameContent.UTDroppedShieldBelt'
}