class UTItem_Armor extends UTInventory;

var int ShieldAmount;

replication
{
	if ((Role == ROLE_Authority) && bNetDirty)
    		ShieldAmount;
}

function GivenTo(Pawn NewOwner, bool bDoNotActivate)
{
	super.GivenTo(NewOwner, bDoNotActivate);

	if (UTPawn(NewOwner) != None)
    {
        AddShieldStrength(UTPawn(NewOwner));
    }
    Destroy(); // Destroy Item After Given To Player To Allow Players To Pickup Multiple Health Items.
}

/** AddShieldStrength()
add shield to appropriate P armor type.
*/
function AddShieldStrength(UTPawn P);

defaultproperties
{
	PickupMessage="Armor"
	ItemName="Armor"
	Begin Object Class=StaticMeshComponent Name=MeshComponentA ObjName=MeshComponentA Archetype=StaticMeshComponent'Engine.Default__StaticMeshComponent'
      CullDistance=8000.000000
      CachedCullDistance=8000.000000
      bUseAsOccluder=False
      CastShadow=False
      bForceDirectLightMap=True
      bCastDynamicShadow=False
      CollideActors=False
   End Object
   DroppedPickupMesh=MeshComponentA
}