class UTGR_RandomDrop extends GameRules config(RandomDrop);

// Default Item Drop % Chance
// Health  -  56%
// Weapon  -  24%
// Powerup -  10%
// Armor -  10%
// Total   - 100%


struct ItemList
{
    var int DropChance; // % Chance Item Will Drop When Picked
    var class<Inventory> ItemClass; // Item Class To Drop
};

var config array<ItemList> RandomItemList;

function bool PreventDeath(Pawn Killed, Controller Killer, class<DamageType> damageType, vector HitLocation)
{
	local array<Inventory> Item;
	local ItemList Selected;
	local int RandomItemCount, count, RandomDropChance;
	local vector DropAngle;
	local rotator DropRotation;
	local Vector	X,Y,Z;
	local Vector ZAxis;

    if ( (NextGameRules != None) && NextGameRules.PreventDeath(Killed,Killer, damageType,HitLocation) )
		return true;

    if (Killed != None)
    {
        RandomItemCount = Rand(6);

        if (RandomItemCount > 0) // Drop Items Only If Item Count > 0
        {
            for (count = 0; count < RandomItemCount; count++)
            {
                ZAxis.X = 0;
                ZAxis.Y = 0;
                ZAxis.Z = ((Rand(200) + 1) + 200);
                DropRotation = Killed.Rotation;
                DropRotation.Yaw = Rand(65536);
				DropAngle = Vector(DropRotation);
				DropAngle = DropAngle * ((Killed.Velocity Dot DropAngle) + ((Rand(500) + 1) + 500)) + ZAxis;
				Selected = RandomItemList[Rand(RandomItemList.Length)];
				if (Selected.ItemClass != None)
				{
				    if (Selected.DropChance > 0)
				    {
				         RandomDropChance = Rand(100);
				         if (RandomDropChance < Selected.DropChance) // Drop Item
				         {
                             Item[count] = Spawn(Selected.ItemClass,Killed);
                             if (Item[count] != None)
                             {

                                 Item[count].InvManager = Killed.InvManager;
                                 GetAxes(Killed.Rotation, X, Y, Z);
                                 Item[count].DropFrom(Killed.Location + 0.8 * Killed.CylinderComponent.CollisionRadius * X - 0.5 * Killed.CylinderComponent.CollisionRadius * Y,DropAngle);
                             }
				         }
				         else // Can't Drop Item So Reduce Count To Try Again
				         {
				             count--;
				         }
				    }
				}
            }
        }
    }

	return false;
}

defaultproperties
{
    RandomItemList(0)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(1)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(2)=(DropChance=40,ItemClass=class'UTWeap_Enforcer')
    RandomItemList(3)=(DropChance=40,ItemClass=class'UTWeap_FlakCannon')
    RandomItemList(4)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(5)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(6)=(DropChance=40,ItemClass=class'UTWeap_LinkGun')
    RandomItemList(7)=(DropChance=5,ItemClass=class'UTWeap_Redeemer_Content')
    RandomItemList(8)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(9)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(10)=(DropChance=40,ItemClass=class'UTWeap_RocketLauncher')
    RandomItemList(11)=(DropChance=40,ItemClass=class'UTWeap_ShockRifle')
    RandomItemList(12)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(13)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(14)=(DropChance=40,ItemClass=class'UTWeap_SniperRifle')
    RandomItemList(15)=(DropChance=40,ItemClass=class'UTWeap_Stinger')
    RandomItemList(16)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(17)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(18)=(DropChance=40,ItemClass=class'UTWeap_Avril_Content')
    RandomItemList(19)=(DropChance=40,ItemClass=class'UTWeap_BioRifle_Content')
    RandomItemList(20)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(21)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(22)=(DropChance=20,ItemClass=class'UTUDamage')
    RandomItemList(23)=(DropChance=20,ItemClass=class'UTInvisibility')
    RandomItemList(24)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(25)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(26)=(DropChance=20,ItemClass=class'UTJumpBoots')
    RandomItemList(27)=(DropChance=20,ItemClass=class'UTBerserk')
    RandomItemList(28)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(29)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(30)=(DropChance=20,ItemClass=class'UTItem_SuperHealth')
    RandomItemList(31)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(32)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(33)=(DropChance=20,ItemClass=class'UTItem_ArmorHelmet')
    RandomItemList(34)=(DropChance=20,ItemClass=class'UTItem_ArmorVest')
    RandomItemList(35)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(36)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
    RandomItemList(37)=(DropChance=20,ItemClass=class'UTItem_ArmorThighpads')
    RandomItemList(38)=(DropChance=10,ItemClass=class'UTItem_ArmorShieldBelt')
    RandomItemList(39)=(DropChance=85,ItemClass=class'UTItem_HealthVial')
    RandomItemList(40)=(DropChance=75,ItemClass=class'UTItem_HealthPack')
}