/**
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
 */
Class UTOrbFix_OnslaughtFlag extends UTOnslaughtFlag_Content;

function SetTeam(int TeamIndex)
{
	local UTTeamInfo OldTeam;

	OldTeam = Team;
	Team = UTOnslaughtGame(WorldInfo.Game).Teams[TeamIndex];

	// Clear the old flag's team so it doesn't stomp me
	if (Team.TeamFlag != none && /* Fix is here >> */ Team.TeamFlag != Self)
		Team.TeamFlag.Team = None;

	Team.TeamFlag = self;

	// If the team has changed, clear the old team's flag reference
	if (OldTeam != Team && OldTeam != None)
		OldTeam.TeamFlag = None;

	UpdateTeamEffects();
}

