/**
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
 */
Class UTMutator_OrbFix extends UTMutator;

function PostBeginPlay()
{
	local UTOnslaughtFlagBase OB;
	local bool bOldbHidden;
	local UTOrbFix_OnslaughtFlag DefaultOrb;

	foreach AllActors(Class'UTOnslaughtFlagBase', OB)
	{
		OB.FlagClass = Class'UTOrbFix_OnslaughtFlag';

		if (OB.myFlag != none)
		{
			bOldbHidden = OB.myFlag.bHidden;
			OB.myFlag.Destroy();


			// There's no 'clean' way to replace the orb on-the-fly (due to the auto 'Rebuilding' state), so some minor hax are needed
			DefaultOrb = UTOrbFix_OnslaughtFlag(FindObject("UTOrbFix.Default__UTOrbFix_OnslaughtFlag",
										Class'UTOrbFix_OnslaughtFlag'));
			ConsoleCommand("Suppress ScriptWarning");
			DefaultOrb.InitialState = 'Wewt';
			OB.myFlag = Spawn(Class'UTOrbFix_OnslaughtFlag');
			DefaultOrb.InitialState = '';
			ConsoleCommand("Unsuppress ScriptWarning");

			OB.myFlag.HomeBase = OB;
			OB.myFlag.StartingHomeBase = OB;
			OB.myFlag.SetTeam(OB.GetTeamNum());
			OB.myFlag.SetHidden(bOldbHidden);

			OB.myFlag.GotoState('Rebuilding');
		}
	}

	// Shouldn't need to hang around when done
	Destroy();
}