class MKWeap_SniperRifle extends UTWeap_SniperRifle; 

var bool bBehindViewPriorToZoom;

simulated function StartZoom(UTPlayerController PC)
{    
    local MKPawn MP;
    
	ZoomCount++;
	if (ZoomCount == 1 && !IsTimerActive('Gotozoom') && IsActiveWeapon() && HasAmmo(0))
	{
        if( !Instigator.IsFirstPerson() )
        {
            bBehindViewPriorToZoom = true;
            MP = MKPawn( Instigator );
            if ( MP != None )
            {
                /** INFO (neoaez) 20080615: there are a number of ways to call the switch from 
                 * first to third-person, but this route insures all the variables are properly
                 * replicated between client and server.
                 * */
                MP.ToggleCamera();
            }
        }
        else { bBehindViewPriorToZoom = false; }
            
		bDisplayCrosshair = false;
		PlayWeaponAnimation( 'WeaponZoomIn',0.2 );
		PlayArmAnimation( 'WeaponZoomIn',0.2 );
		bAbortZoom = false;
		SetTimer( 0.2, false, 'Gotozoom' );
	}
}

simulated function LeaveZoom()
{
	local UTPlayerController PC;

	bAbortZoom = false;
	PC = UTPlayerController(Instigator.Controller);
	if (PC != none)
	{
		PC.EndZoom();
	}
	ZoomCount = 0;
	if(Instigator.IsFirstPerson())
	{
        //DEBUG
        //LogInternal("MKLOG -> LeaveZoom: Instigator is FIRST PERSON");
        //DEBUG
		ChangeVisibility(true);
	}
    
	PlayWeaponAnimation('WeaponZoomOut',0.3);
	PlayArmAnimation('WeaponZoomOut',0.3);
	SetTimer(0.3,false,'RestartCrosshair');
    if( bBehindViewPriorToZoom )
    {
        SetTimer(0.0001,false,'RestartBehindView');
    }
}

simulated function RestartBehindView()
{
    
	local UTPlayerController PC;
    local MKPawn MP;
    
    //DEBUG
    //LogInternal ("MKLOG -> RestartBehindView: CALLED");
    //DEBUG
    
    PC = UTPlayerController(Instigator.Controller);
    if (PC != None)
    {
        if(Instigator.IsFirstPerson())
        {
            MP = MKPawn( Instigator );
            if ( MP != None )
            {
                //DEBUG
                //LogInternal ("MKLOG -> RestartBehindView: Setting BEHINDVIEW to TRUE");
                //DEBUG

                /** INFO (neoaez) 20080615: there are a number of ways to call the switch from 
                 * first to third-person, but this route insures all the variables are properly
                 * replicated between client and server.
                 * */
                MP.ToggleCamera();
            }
        }
    }
}

simulated function ChangeVisibility(bool bIsVisible)
{
    //DEBUG
    //LogInternal ("MKLOG -> ChangeVisibility: CALLED");
    //DEBUG
    
	super.Changevisibility(bIsvisible);
	if(bIsVisible)
	{
        //DEBUG
        //LogInternal ("MKLOG -> ChangeVisibility: bIsVisible is TRUE");
        //DEBUG
        
		PlayArmAnimation('WeaponZoomOut',0.00001); // to cover zooms ended while in 3p
	}
    /** INFO (neoaez) 20080615: removed this from the original code since we ARE allowing
     * zoom to work while in third-person
     * */
	//if(!Instigator.IsFirstPerson()) // to be consistent with not allowing zoom from 3p
	//{
	//	LeaveZoom();
	//}

}


defaultproperties
{
}
