class MKPawn extends UTPawn
    config( MK3rdPersonMutator );

/** INFO (neoaez) 20071128: config file variables
 * */
var config float CameraScaleAdjustSensitivity, MyCameraScale;
var config bool bStartIn3rdPerson;

var float CameraScalePriorToFeignDeath, CurrentCameraScalePriorToFeignDeath, MinimumCameraScale, MaximumCameraScale;
var bool  bBehindViewPriorToFeignDeath;

reliable client function ClientSetCameraScale( float scale )
{
    SetCameraScale( scale );
}

function SetCameraScale( float scale )
{
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.SetCameraScale: MyCameraScale:" @ MyCameraScale );
    //DEBUG
    
    /** INFO (neoaez) 20071128: On death and at the beginning of a new match the camera scale gets reset to its default 9.0
     * We are going to check a local variable for a value.   If it is not 0 then we use it, otherwise let the engine do what 
	 * it wants 
	 * */
    if( MyCameraScale > 0 )
    {
        CameraScale = MyCameraScale;
        CurrentCameraScale = MyCameraScale;
    }
    else
    {
        CameraScale = scale;
        CurrentCameraScale = scale;
    }    
}

reliable client function ClientSetStartingCameraView()
{
    local UTPlayerController PC;
    local name NewMode;
    
  	PC = UTPlayerController( Controller );
	if ( PC != None )
	{
        if( !bStartIn3rdPerson )
        {
            NewMode = 'FirstPerson';
        }
       else
       {
           NewMode = 'ThirdPerson';
       }
       PC.ServerCamera( NewMode );
	}
}

reliable client function ClientSetValidCameraScaleValues( float min, float max )
{
    MinimumCameraScale = min;
    MaximumCameraScale = max;
}

exec function IncreaseCameraScale()
{
    local UTPlayerController PC;
    
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.IncreaseCameraScale: CameraScaleAdjustSensitivity:" @ CameraScaleAdjustSensitivity );
    //DEBUG
    
    /** INFO (neoaez) 20071128: If we are in first-person then ignore this command
	 * */
	PC = UTPlayerController( Controller );
    if ( PC != None )
	{
        if( PC.UsingFirstPersonCamera() ) { return; }
     
        if( CameraScaleAdjustSensitivity <= 0 ) { CameraScaleAdjustSensitivity = 1.0; }
        CameraScale = CameraScale + 1.0 * CameraScaleAdjustSensitivity;
     
        if( CameraScale >= MaximumCameraScale )
        {
            CameraScale = MaximumCameraScale;
        }
        MyCameraScale = CameraScale;
        SaveConfig();
    }
}

exec function DecreaseCameraScale()
{
    local UTPlayerController PC;
    
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.DecreaseCameraScale: CameraScaleAdjustSensitivity:" @ CameraScaleAdjustSensitivity );
    //DEBUG
    
    /** INFO (neoaez) 20071128: If we are in first-person then ignore this command
	 * */
	PC = UTPlayerController( Controller );
    if ( PC != None )
	{
        if( PC.UsingFirstPersonCamera() ) { return; }
    
        if( CameraScaleAdjustSensitivity <= 0 ) { CameraScaleAdjustSensitivity = 1.0; }
        CameraScale = CameraScale - 1.0 * CameraScaleAdjustSensitivity;
    
        if( CameraScale <= MinimumCameraScale )
        {
            CameraScale = MinimumCameraScale;
        }
        MyCameraScale = CameraScale;
        SaveConfig();
    }
}

exec function ToggleCamera()
{    
    local UTPlayerController PC;
    local bool bCurrentBehindView;
    local name NewMode;
    
  	PC = UTPlayerController( Controller );
	if ( PC != None )
	{
        bCurrentBehindView = PC.bBehindView;
        
        if( bCurrentBehindView )
        {
            NewMode = 'FirstPerson';
        }
        else
        {
            NewMode = 'ThirdPerson';
        }
        PC.ServerCamera( NewMode );
	}
}

simulated function bool CalcThirdPersonCam( float fDeltaTime, out vector out_CamLoc, out rotator out_CamRot, out float out_FOV )
{
	local vector CamStart, HitLocation, HitNormal, CamDir;
	local float DesiredCameraZOffset;

	ModifyRotForDebugFreeCam(out_CamRot);

	CamStart = Location;

	if ( bIsHero )
	{
		// use "hero" cam
		SetHeroCam(out_CamRot);
	}
	else
	{
		DesiredCameraZOffset = (Health > 0) ? 1.5 * GetCollisionHeight() + Mesh.Translation.Z : 0.f;
		CameraZOffset = (fDeltaTime < 0.2) ? DesiredCameraZOffset * 5 * fDeltaTime + (1 - 5*fDeltaTime) * CameraZOffset : DesiredCameraZOffset;
	}
	CamStart.Z += CameraZOffset;
	CamDir = Vector(out_CamRot) * GetCollisionRadius() * CurrentCameraScale;

	if ( (Health <= 0) || bFeigningDeath )
	{
		// adjust camera position to make sure it's not clipping into world
		// @todo fixmesteve.  Note that you can still get clipping if FindSpot fails (happens rarely)
		FindSpot(GetCollisionExtent(),CamStart);
	}
    if ( CurrentCameraScale < CameraScale )
    {
        //DEBUG
        //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was smaller): [PRIOR to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
        //DEBUG

        CurrentCameraScale = FMin( CameraScale, CurrentCameraScale + 5 * FMax( CameraScale - CurrentCameraScale, 0.3 )*fDeltaTime );
        //DEBUG
        //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was smaller): [After to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
        //DEBUG
        
    }
    else if ( CurrentCameraScale > CameraScale )
    {
        //DEBUG
        //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was larger): [PRIOR to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
        //DEBUG
        
        /** INFO (neoaez) 20080614: fixes a logic bug with EPIC's original code.  
         * Changed the second FMax state in the line below from:
         * FMax( CameraScale - CurrentCameraScale, 0.3 )*fDeltaTime );
         * to:
         * FMax( CurrentCameraScale - CameraScale, 0.3 )*fDeltaTime );
         * Since the CurrentCameraScale value is more than CameraScale the original code would result in a negative value compared against
         * the 0.3 value.  Of course the 0.3 value would win every time.  This is not desirable.
         * */
        CurrentCameraScale = FMax( CameraScale, CurrentCameraScale - 5 * FMax( CurrentCameraScale - CameraScale, 0.3 )*fDeltaTime );
        
        //DEBUG
        //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was larger): [After to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
        //DEBUG
       
    }
	if (CamDir.Z > GetCollisionHeight())
	{
		CamDir *= square(cos(out_CamRot.Pitch * 0.0000958738)); // 0.0000958738 = 2*PI/65536
	}
	out_CamLoc = CamStart - CamDir;
	if (Trace(HitLocation, HitNormal, out_CamLoc, CamStart, false, vect(12,12,12)) != None)
	{
		out_CamLoc = HitLocation;
		return false;
	}
	return true;
}

state FeigningDeath
{
	ignores ServerHoverboard, SwitchWeapon, QuickPick, FaceRotation, ForceRagdoll, AdjustCameraScale, SetMovementPhysics;

	exec simulated function FeignDeath()
	{
		if ( bFeigningDeath )
		{
			Global.FeignDeath();
		}
	}

	reliable server function ServerFeignDeath()
	{
		if ( Role == ROLE_Authority && !WorldInfo.GRI.bMatchIsOver && !IsTimerActive( 'FeignDeathDelayTimer' ) && bFeigningDeath )
		{
			bFeigningDeath = false;
			PlayFeignDeath();
		}
	}

	event bool EncroachingOn( Actor Other )
	{
		// don't abort moves in ragdoll
		return false;
	}

	simulated function bool CanThrowWeapon()
	{
		return false;
	}

	simulated function Tick( float DeltaTime )
	{
		local rotator NewRotation;

		if ( bPlayingFeignDeathRecovery && PlayerController( Controller ) != None )
		{
			// interpolate Controller yaw to our yaw so that we don't get our rotation snapped around when we get out of feign death
			NewRotation = Controller.Rotation;
			NewRotation.Yaw = RInterpTo( NewRotation, Rotation, DeltaTime, 2.0 ).Yaw;
			Controller.SetRotation( NewRotation );

			if ( WorldInfo.TimeSeconds - FeignDeathRecoveryStartTime > 0.8 )
			{
				CameraScale = 1.0;
			}
		}
	}

	simulated function bool CalcThirdPersonCam( float fDeltaTime, out vector out_CamLoc, out rotator out_CamRot, out float out_FOV )
	{
		local vector CamStart, HitLocation, HitNormal, CamDir;
		local RB_BodyInstance RootBodyInst;
		local matrix RootBodyTM;

		if ( CurrentCameraScale < CameraScale )
		{
            //DEBUG
            //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was smaller): [PRIOR to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
            //DEBUG

			CurrentCameraScale = FMin( CameraScale, CurrentCameraScale + 5 * FMax( CameraScale - CurrentCameraScale, 0.3 )*fDeltaTime );
            //DEBUG
            //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was smaller): [After to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
            //DEBUG
            
		}
		else if ( CurrentCameraScale > CameraScale )
		{
            //DEBUG
            //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was larger): [PRIOR to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
            //DEBUG
            
			CurrentCameraScale = FMax( CameraScale, CurrentCameraScale - 5 * FMax( CurrentCameraScale - CameraScale, 0.3 )*fDeltaTime );
            
            //DEBUG
            //WarnInternal( "MKLOG -> MKPawn.CalcThirdPersonCam (was larger): [After to Adjustment]CurrentCameraScale:" @ CurrentCameraScale );
            //DEBUG
           
		}

		//CamStart = Mesh.Bounds.Origin + vect(0,0,1) * BaseEyeHeight; (Replaced with below due to Bounds being updated 2x per frame 
		//which can result in jitter-cam
		CamStart = Mesh.GetPosition();
		if( Mesh.PhysicsAssetInstance != None )
		{
			RootBodyInst = Mesh.PhysicsAssetInstance.Bodies[Mesh.PhysicsAssetInstance.RootBodyIndex];
			if( RootBodyInst.IsValidBodyInstance() )
			{
				RootBodyTM = RootBodyInst.GetUnrealWorldTM();
				CamStart.X = RootBodyTM.WPlane.X;
				CamStart.Y = RootBodyTM.WPlane.Y;
				CamStart.Z = RootBodyTM.WPlane.Z;
			}
		}
		CamStart += vect( 0,0,1 ) * BaseEyeHeight;

		CamDir = vector( out_CamRot ) * GetCollisionRadius() * CurrentCameraScale;
//		`log("Mesh"@Mesh.Bounds.Origin@" --- Base Eye Height "@BaseEyeHeight);

		if ( CamDir.Z > GetCollisionHeight() )
		{
			CamDir *= square( cos( out_CamRot.Pitch * 0.0000958738 ) ); // 0.0000958738 = 2*PI/65536
		}
		out_CamLoc = CamStart - CamDir;
		if ( Trace( HitLocation, HitNormal, out_CamLoc, CamStart, false, vect( 12,12,12 ) ) != None )
		{
			out_CamLoc = HitLocation;
		}
		return true;
	}

	simulated event OnAnimEnd( AnimNodeSequence SeqNode, float PlayedTime, float ExcessTime )
	{
		if ( Physics != PHYS_RigidBody && !bPlayingFeignDeathRecovery )
		{
			// blend out of feign death animation
			if ( FeignDeathBlend != None )
			{
				FeignDeathBlend.SetBlendTarget( 0.0, 0.5 );
			}
			GotoState( 'Auto' );
		}
	}

	simulated event BeginState( name PreviousStateName )
	{
		local UTPlayerController PC;
		local UTWeapon UTWeap;

		bCanPickupInventory = false;
		StopFiring();
		bNoWeaponFiring = true;

		UTWeap = UTWeapon( Weapon );
		if ( UTWeap != None )
		{
			UTWeap.PlayWeaponPutDown();
		}
		if( UTWeap != none && PC != none )
		{
			UTPlayerController( Controller ).EndZoom();
		}

		PC = UTPlayerController( Controller );
		if ( PC != None )
		{
            CameraScalePriorToFeignDeath = CameraScale;
            CurrentCameraScalePriorToFeignDeath = CurrentCameraScale;
            bBehindViewPriorToFeignDeath = PC.bBehindView;
			PC.SetBehindView( true );
			CurrentCameraScale = 1.5;
			CameraScale = 2.25;
		}

		DropFlag();
	}

	simulated function EndState( name NextStateName )
	{
		local UTPlayerController PC;
		local UTPawn P;

		if ( NextStateName != 'Dying' )
		{
			bNoWeaponFiring = default.bNoWeaponFiring;
			bCanPickupInventory = default.bCanPickupInventory;
			Global.SetMovementPhysics();
			PC = UTPlayerController( Controller );
			if ( PC != None )
			{
               PC.SetBehindView( bBehindViewPriorToFeignDeath );
			}

             CurrentCameraScale = CurrentCameraScalePriorToFeignDeath;
			CameraScale = CameraScalePriorToFeignDeath;
			bForcedFeignDeath = false;
			bPlayingFeignDeathRecovery = false;

			// jump away from other feigning death pawns to make sure we don't get stuck
			foreach TouchingActors( class'UTPawn', P )
			{
				if ( P.IsInState( 'FeigningDeath' ) )
				{
					JumpOffPawn();
				}
			}
		}
	}
}

/** INFO (neoaez) 20080610: Thanks to the ActionCam mutator for this fix. 
 * Correct aim to sync projectile trajectory with camera trace
 * */
simulated singular function Rotator GetBaseAimRotation()
{
    local vector    POVLoc;
    local rotator   POVRot;
    local UTPlayerController PC;

    local vector TargetLocation;
    local vector HitLocation, HitNormal;

    // If we have a controller, by default we aim at the player's 'eyes' direction
    // that is by default Controller.Rotation for AI, and camera (crosshair) rotation for human players.
    if( Controller != None && !InFreeCam() )
    {
        Controller.GetPlayerViewPoint(POVLoc, POVRot);        
        PC = UTPlayerController( Controller );
        
        //DEBUG
        //LogInternal( "MKLOG -> MKPawn.GetBaseAimRotation: PC.bBehindView = "@PC.bBehindView );
        //DEBUG
        
        /** INFO (neoaez) 20080615: If we are in first-person then there is no need to correct the original
         * aim code provided by EPIC.  
         * */
        if ( !PC.bBehindView )
        {
            
            //DEBUG
            //LogInternal( "MKLOG -> MKPawn.GetBaseAimRotation: Was first-person so returning POVRot" );
            //DEBUG           
            return POVRot; 
        }
        //DEBUG
        //LogInternal( "MKLOG -> MKPawn.GetBaseAimRotation: Not first-person so adjusting POVRot" );
        //DEBUG           
        
        /** INFO (neoaez) 20080610: changed ActionCam code in the following line from this:        
		 * TargetLocation = POVLoc + (vector(POVRot)*100000);
		 * to remove arbitray scalar used in trace to that of the weapon equipped.  This follows the
		 * example set out by the function GetWeaponAim in UTVehicle  Fixes an accuracy issue when
         * in third-person.
		 * */
        TargetLocation = POVLoc + ( vector( POVRot ) * Weapon.GetTraceRange() );
        if( Trace( HitLocation, HitNormal, TargetLocation, POVLoc, false,,,TRACEFLAG_Bullet ) == None )
        {
            HitLocation = TargetLocation;
        }
        POVRot = rotator( HitLocation - GetWeaponStartTraceLocation() );

        return POVRot;
    }

    // If we have no controller, we simply use our rotation
    POVRot = Rotation;

    // If our Pitch is 0, then use RemoveViewPitch
    if( POVRot.Pitch == 0 )
    {
        POVRot.Pitch = RemoteViewPitch << 8;
    }

    return POVRot;
}

reliable client function ClientInitInteraction()
{
    local PlayerController PC;
    local int i;
    local bool bFound;
    
    PC = PlayerController( Controller );
    if ( PC == None ) { return; }

    //DEBUG
    //LogInternal("MKLOG -> MKPawn.ClientInitInteraction: Inspecting "$PC$" for interactions :");
    //DEBUG
    
    for (i = 0; i < PC.Interactions.Length; i++)
    {
        //DEBUG
        //LogInternal("MKLOG -> MKPawn.ClientInitInteraction: ... found "$PC.Interactions[i]);
        //DEBUG
    
        if (MK3rdPersonMutatorInteraction( PC.Interactions[i] ) != None) { bFound = true; }               
    }

    if (!bFound)
    {
        PC.Interactions.Insert( 0, 1 );
        PC.Interactions[0] = new( PC ) class'MK3rdPersonMutatorInteraction';
        MK3rdPersonMutatorInteraction( PC.Interactions[0] ).InitInteraction( PC );
        
        //DEBUG
        //LogInternal( "MKLOG -> MKPawn.ClientInitInteraction: PC added a MK3rdPersonMutatorInteraction" );
        //DEBUG
    }
}

defaultproperties
{
}
