class MK3rdPersonMutator extends UTMutator 
    config( MK3rdPersonMutator );

var config string Validate;
var config float DefaultCameraScale, MinimumCameraScale, MaximumCameraScale;
var config bool bStartIn3rdPerson;

simulated function InitMutator(string options, out string ErrorMessage)
{
    //DEBUG
    //LogInternal("MKLOG -> MK3rdPersonMutator.InitMutator: CALLED");
    //DEBUG

    //INFO (neoaez)  20071124: Validate the INI and recreate if missing
    if ( Validate != "VALID" )
    {
        LogInternal( "MKLOG -> MK3rdPersonMutator.InitMutator: Config file was not valid.  Recreating." );
        Validate = "VALID";
        DefaultCameraScale = 9.0;
        MinimumCameraScale = 4.0;
        MaximumCameraScale = 10.0;
    }
    /** INFO (neoaez) 20071124: check for valid values
	 * */
    
    /** INFO (neoaez) 20071128: Let's avoid some quirkiness by making sure the minimum value is not greater than our maximum value.  
	 * If it is let's just make them equal.
	 * */
    if( MinimumCameraScale > MaximumCameraScale ) { MaximumCameraScale = MinimumCameraScale; }
    
    /** INFO (neoaez) 20071128: Let's make sure the values are valid.  I pulled these values from EPIC's code.
	 * */
    if ( MaximumCameraScale > 40.0 ) { MaximumCameraScale = 40.0; }
    if ( MinimumCameraScale < 1.0 ) { MinimumCameraScale = 1.0; }

    if ( DefaultCameraScale > 40.0 ) { DefaultCameraScale = 40.0; }
    if ( DefaultCameraScale < 1.0 ) { DefaultCameraScale = 1.0; }

    /** INFO (neoaez) 20071128: Write out the config with the current values.
	 * */
    SaveConfig();

    /** INFO (neoaez) 20071124: continue the mutator chain
	 * */
    Super.InitMutator( options, ErrorMessage );
}

simulated function ModifyPlayer( Pawn Other )
{
    local UTPawn P;
    local MKPawn MP;
    //local PlayerController PC;
    //local bool bFound;
    //local int i;
 
    //DEBUG
    //LogInternal ( "MKLOG -> MK3rdPersonMutator.ModifyPlayer: CALLED" );
    //DEBUG

    P = UTPawn( Other );
    if( P != None )
    {

        MP = MKPawn( P );
        if ( MP != None )
        {
            /** INFO (neoaez) 20071128: Send the valid values to the client.
			 * */            
            MP.ClientSetValidCameraScaleValues( MinimumCameraScale, MaximumCameraScale );
            MP.ClientSetCameraScale( DefaultCameraScale );
            MP.ClientSetStartingCameraView();
            MP.ClientInitInteraction();
        }
    }
    Super.ModifyPlayer( Other );
}

simulated function PostBeginPlay()
{
	local UTGame Game;
	local int i;

    //DEBUG
    //LogInternal ( "MKLOG -> MK3rdPersonMutator.PostBeginPlay: CALLED" );
    //DEBUG

    Super.PostBeginPlay();

	// replace default weapons
	Game = UTGame( WorldInfo.Game );
	if ( Game != None )
	{
        /** INFO (neoaez) 20071124: set the default pawn class to our own
		 * */
        Game.DefaultPawnClass = class'MK3rdPersonMutator.MKPawn';
		for ( i = 0; i < Game.DefaultInventory.length; i++ )
		{
            /** INFO (neoaez) 20080610: look for instances of the UT Sniper rifle and replace it with our own
			 * This incorporates our fix that allows us to switch back to first person when zooming
			 * */
			if ( Game.DefaultInventory[i].IsA( 'UTWeap_SniperRifle' ) )
			{
					Game.DefaultInventory[i] = class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_SniperRifle", class'Class' ) );
			}
            else
            {
                //DEBUG
                //LogInternal( "MKLOG -> MK3rdPersonMutator.PostBeginPlay: Cycling through Game.DefaultInventory:"@Game.DefaultInventory[i] );
                //DEBUG
            }
            /** INFO (neoaez) 20080610: look for instances of the UT Enforcer and replace it with our own
			 * This allows us to incorporate a fix that stops the first person arm meshes from appearing when we are in 3rd person and equip
			 * dual enforcers for the first time
			 * */
			if ( Game.DefaultInventory[i].IsA( 'UTWeap_Enforcer' ) )
			{
					Game.DefaultInventory[i] = class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_Enforcer", class'Class' ) );
			}
            else
            {
                //DEBUG
                //LogInternal( "MKLOG -> MK3rdPersonMutator.PostBeginPlay: Cycling through Game.DefaultInventory:"@Game.DefaultInventory[i] );
                //DEBUG
            }            
		}
	}
}

simulated function bool CheckReplacement( Actor Other )
{
	local UTWeaponPickupFactory WeaponPickup;
	local UTWeaponLocker Locker;
    local int i;

    //DEBUG
    //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: CALLED" );
    //DEBUG

    WeaponPickup = UTWeaponPickupFactory( Other );
	if ( WeaponPickup != None )
	{
        //DEBUG
        //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: WeaponPickup:"@WeaponPickup );
        //DEBUG

        if ( WeaponPickup.WeaponPickupClass == class'UTWeap_SniperRifle' )
		{
            //DEBUG
            //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: UTWeap_SniperRifle found and is being replaced." );
            //DEBUG

			WeaponPickup.WeaponPickupClass = class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_SniperRifle", class'Class' ) );
			WeaponPickup.InitializePickup();
		}
        else
        {
            //DEBUG
            //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: WeaponPickup.WeaponPickupClass:"@WeaponPickup.WeaponPickupClass );
            //DEBUG
        }
        
        if ( WeaponPickup.WeaponPickupClass == class'UTWeap_Enforcer' )
		{
            //DEBUG
            //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: UTWeap_Enforcer found and is being replaced." );
            //DEBUG

			WeaponPickup.WeaponPickupClass = class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_Enforcer", class'Class' ) );
			WeaponPickup.InitializePickup();
		}
        else
        {
            //DEBUG
            //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: WeaponPickup.WeaponPickupClass:"@WeaponPickup.WeaponPickupClass );
            //DEBUG
        }
	}
	else
	{
		Locker = UTWeaponLocker( Other );
		if ( Locker != None )
		{
			for ( i = 0; i < Locker.Weapons.length; i++ )
			{
                //DEBUG
                //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: Locker.Weapons[i].WeaponClass:"@Locker.Weapons[i].WeaponClass );
                //DEBUG

                if ( Locker.Weapons[i].WeaponClass.IsA( 'UTWeap_SniperRifle' ) )
				{
                   Locker.ReplaceWeapon( i, class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_SniperRifle", class'Class' ) ) );
				}
                
                if ( Locker.Weapons[i].WeaponClass.IsA( 'UTWeap_Enforcer' ) )
				{
                   Locker.ReplaceWeapon( i, class<UTWeapon>( DynamicLoadObject( "MK3rdPersonMutator.MKWeap_Enforcer", class'Class' ) ) );
				}                
			}
		}
        else
        {
            //DEBUG
            //LogInternal( "MKLOG -> MK3rdPersonMutator.CheckReplacement: Locker == NONE" );
            //DEBUG
        }
	}
	return true;
}

defaultproperties
{
    Name="MK3rdPersonMutator"
}
