class MKWeap_SniperRifle extends UTWeap_SniperRifle; 

simulated function StartZoom(UTPlayerController PC)
{    
	ZoomCount++;
	if (ZoomCount == 1 && !IsTimerActive('Gotozoom') && IsActiveWeapon() && HasAmmo(0))
	{
        if(!Instigator.IsFirstPerson())
        {
            PC.SetCameraMode( 'FirstPerson' );
        }
		bDisplayCrosshair = false;
		PlayWeaponAnimation('WeaponZoomIn',0.2);
		PlayArmAnimation('WeaponZoomIn',0.2);
		bAbortZoom = false;
		SetTimer(0.2, false, 'Gotozoom');
	}
}

simulated function LeaveZoom()
{
	local UTPlayerController PC;

	bAbortZoom = false;
	PC = UTPlayerController(Instigator.Controller);
	if (PC != none)
	{
		PC.EndZoom();
	}
	ZoomCount = 0;
	if(Instigator.IsFirstPerson())
	{
        //DEBUG
        //LogInternal("MKLOG -> LeaveZoom: Instigator is FIRST PERSON");
        //DEBUG
		ChangeVisibility(true);
	}

	PlayWeaponAnimation('WeaponZoomOut',0.3);
	PlayArmAnimation('WeaponZoomOut',0.3);
	SetTimer(0.3,false,'RestartCrosshair');
    SetTimer(0.0001,false,'RestartBehindView');
}

simulated function RestartBehindView()
{
    
	local UTPlayerController PC;
    
    //DEBUG
    //LogInternal ("MKLOG -> RestartBehindView: CALLED");
    //DEBUG
    
    PC = UTPlayerController(Instigator.Controller);
    if (PC != None)
    {
        if(Instigator.IsFirstPerson())
        {
            //DEBUG
            //LogInternal ("MKLOG -> RestartBehindView: Setting BEHINDVIEW to TRUE");
            //DEBUG
            
            PC.SetCameraMode( 'ThirdPerson' );
        }
    }
}

simulated function ChangeVisibility(bool bIsVisible)
{
    //DEBUG
    //LogInternal ("MKLOG -> ChangeVisibility: CALLED");
    //DEBUG
    
	super.Changevisibility(bIsvisible);
	if(bIsVisible)
	{
        //DEBUG
        //LogInternal ("MKLOG -> ChangeVisibility: bIsVisible is TRUE");
        //DEBUG
        
		PlayArmAnimation('WeaponZoomOut',0.00001); // to cover zooms ended while in 3p
	}
	if(!Instigator.IsFirstPerson()) // to be consistent with not allowing zoom from 3p
	{
		//LeaveZoom();
	}

}


defaultproperties
{
    //ItemName="Sniper Rifle (TPS)"
}
