class MKWeap_Enforcer extends UTWeap_Enforcer;

/**
 * Become a dual firing weapon.  Right now this isn't important unless the instigator is the local client.
 * If it is, then show the second mesh and play any needed "Equipping" animations
 */
simulated function BecomeDual()
{
    local UTPawn P;

    IconCoordinates = (DualMode == EDM_SingleWeapon) ? default.IconCoordinates : DualIconCoordinates;
    if ( DualMode == EDM_DualEquipping )
    {
        MaxAmmoCount = 2 * Default.MaxAmmoCount;
        if (LeftMesh == None)
        {
            LeftMesh = UTSkeletalMeshComponent(new(self) Mesh.Class(Mesh));
            LeftMesh.SetScale3D(Mesh.Scale3D * vect(1,-1,1));
            AttachComponent(LeftMesh);
        }
        P = UTPawn(Instigator);
        if (P != None)
        {
            if (P.WeaponOverlayFlags != 0)
            {
                CreateOverlayMesh();
            }
            SetWeaponOverlayFlags(P);
        }
        SetTimer(DualEquiptime, false, 'DualEquipDone');
        if (P != None)
        {
            if (!Mesh.HiddenGame)
            {
                LeftMesh.SetHidden(false);
                if (WorldInfo.NetMode != NM_DedicatedServer && P.ArmsMesh[1] != None && Instigator.Weapon == self)
                {
                    bUsesOffhand = true;
                    P.AttachComponent(P.ArmsMesh[1]);   
                    //INFO (neoaez) 20080608: added this check to prevent the FirstPerson arm meshes from
                    //becoming seen when in thirdperson and equipping dual enforcers
                    if( P.IsFirstPerson() ) 
                    { 
                        P.ArmsMesh[1].SetHidden(false); 
                    }
                }
            }

            P.bDualWielding = true;
            if (P.CurrentWeaponAttachment != None)
            {
                P.CurrentWeaponAttachment.SetDualWielding(true);
            }
        }
        if (EnforcerMuzzleFlashPSC[1] != None)
        {
            EnforcerMuzzleFlashPSC[1].SetFOV(LeftMesh.FOV);
            LeftMesh.AttachComponentToSocket(EnforcerMuzzleFlashPSC[1], MuzzleFlashSocket);
        }

        PlayWeaponAnimation( WeaponDualEqipAnim, DualEquiptime,, LeftMesh );
        PlayArmAnimation( WeaponDualEqipAnim, DualEquiptime, true,, LeftMesh );
    }
}

defaultproperties
{
}
