class MKPawn extends UTPawn
    config( MK3rdPersonMutator );

//INFO (neoaez) 20071128: config file varialbes
var config float CameraScaleAdjustSensitivity, MyCameraScale;
var config bool bStartIn3rdPerson;

var float CameraScalePriorToFeignDeath, CurrentCameraScalePriorToFeignDeath, MinimumCameraScale, MaximumCameraScale;
var bool  bBehindViewPriorToFeignDeath;

reliable client function ClientSetCameraScale( float scale )
{
    SetCameraScale( scale );
}

function SetCameraScale( float scale )
{
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.SetCameraScale: MyCameraScale:" @ MyCameraScale );
    //DEBUG
    
    /** INFO (neoaez) 20071128: On death and at the beginning of a new match the camera scale gets reset to its default 9.0
    * We are going to check a local variable for a value.   If it is not 0 then we use it, otherwise let the engine do what it wants 
    */
    if( MyCameraScale > 0 )
    {
        CameraScale = MyCameraScale;
        CurrentCameraScale = MyCameraScale;
    }
    else
    {
        CameraScale = scale;
        CurrentCameraScale = scale;
    }    
}

reliable client function ClientSetStartingCameraView()
{
    local UTPlayerController PC;
    local name NewMode;
    
  	PC = UTPlayerController( Controller );
	if ( PC != None )
	{
        if( !bStartIn3rdPerson )
        {
            NewMode = 'FirstPerson';
        }
       else
       {
           NewMode = 'ThirdPerson';
       }
       PC.ServerCamera( NewMode );
	}
}

reliable client function ClientSetValidCameraScaleValues( float min, float max )
{
    MinimumCameraScale = min;
    MaximumCameraScale = max;
}

exec function IncreaseCameraScale()
{
    local UTPlayerController PC;
    
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.IncreaseCameraScale: CameraScaleAdjustSensitivity:" @ CameraScaleAdjustSensitivity );
    //DEBUG
    
    /** INFO (neoaez) 20071128: If we are in first-person then ignore this command
    */
	PC = UTPlayerController( Controller );
    if ( PC != None )
	{
        if( PC.UsingFirstPersonCamera() ) { return; }
     
        if( CameraScaleAdjustSensitivity <= 0 ) { CameraScaleAdjustSensitivity = 1.0; }
        CameraScale = CameraScale + 1.0 * CameraScaleAdjustSensitivity;
     
        if( CameraScale >= MaximumCameraScale )
        {
            CameraScale = MaximumCameraScale;
        }
        MyCameraScale = CameraScale;
        SaveConfig();
    }
}

exec function DecreaseCameraScale()
{
    local UTPlayerController PC;
    
    //DEBUG
    //LogInternal( "MKLOG -> MKPawn.DecreaseCameraScale: CameraScaleAdjustSensitivity:" @ CameraScaleAdjustSensitivity );
    //DEBUG
    
    /** INFO (neoaez) 20071128: If we are in first-person then ignore this command
    */
	PC = UTPlayerController( Controller );
    if ( PC != None )
	{
        if( PC.UsingFirstPersonCamera() ) { return; }
    
        if( CameraScaleAdjustSensitivity <= 0 ) { CameraScaleAdjustSensitivity = 1.0; }
        CameraScale = CameraScale - 1.0 * CameraScaleAdjustSensitivity;
    
        if( CameraScale <= MinimumCameraScale )
        {
            CameraScale = MinimumCameraScale;
        }
        MyCameraScale = CameraScale;
        SaveConfig();
    }
}

exec function ToggleCamera()
{    
    local UTPlayerController PC;
    local bool bCurrentBehindView;
    local name NewMode;
    
  	PC = UTPlayerController( Controller );
	if ( PC != None )
	{
        bCurrentBehindView = PC.bBehindView;
        
        if( bCurrentBehindView )
        {
            NewMode = 'FirstPerson';
        }
        else
        {
            NewMode = 'ThirdPerson';
        }
        PC.ServerCamera( NewMode );
	}
}

state FeigningDeath
{
	ignores ServerHoverboard, SwitchWeapon, QuickPick, FaceRotation, ForceRagdoll, AdjustCameraScale, SetMovementPhysics;

	exec simulated function FeignDeath()
	{
		if ( bFeigningDeath )
		{
			Global.FeignDeath();
		}
	}

	reliable server function ServerFeignDeath()
	{
		if ( Role == ROLE_Authority && !WorldInfo.GRI.bMatchIsOver && !IsTimerActive( 'FeignDeathDelayTimer' ) && bFeigningDeath )
		{
			bFeigningDeath = false;
			PlayFeignDeath();
		}
	}

	event bool EncroachingOn( Actor Other )
	{
		// don't abort moves in ragdoll
		return false;
	}

	simulated function bool CanThrowWeapon()
	{
		return false;
	}

	simulated function Tick( float DeltaTime )
	{
		local rotator NewRotation;

		if ( bPlayingFeignDeathRecovery && PlayerController( Controller ) != None )
		{
			// interpolate Controller yaw to our yaw so that we don't get our rotation snapped around when we get out of feign death
			NewRotation = Controller.Rotation;
			NewRotation.Yaw = RInterpTo( NewRotation, Rotation, DeltaTime, 2.0 ).Yaw;
			Controller.SetRotation( NewRotation );

			if ( WorldInfo.TimeSeconds - FeignDeathRecoveryStartTime > 0.8 )
			{
				CameraScale = 1.0;
			}
		}
	}

	simulated function bool CalcThirdPersonCam( float fDeltaTime, out vector out_CamLoc, out rotator out_CamRot, out float out_FOV )
	{
		local vector CamStart, HitLocation, HitNormal, CamDir;
		local RB_BodyInstance RootBodyInst;
		local matrix RootBodyTM;

		if ( CurrentCameraScale < CameraScale )
		{
			CurrentCameraScale = FMin( CameraScale, CurrentCameraScale + 5 * FMax( CameraScale - CurrentCameraScale, 0.3 )*fDeltaTime );
		}
		else if ( CurrentCameraScale > CameraScale )
		{
			CurrentCameraScale = FMax( CameraScale, CurrentCameraScale - 5 * FMax( CameraScale - CurrentCameraScale, 0.3 )*fDeltaTime );
		}

//		CamStart = Mesh.Bounds.Origin + vect(0,0,1) * BaseEyeHeight; (Replaced with below due to Bounds being updated 2x per frame which can result in jitter-cam
		CamStart = Mesh.GetPosition();
		if( Mesh.PhysicsAssetInstance != None )
		{
			RootBodyInst = Mesh.PhysicsAssetInstance.Bodies[Mesh.PhysicsAssetInstance.RootBodyIndex];
			if( RootBodyInst.IsValidBodyInstance() )
			{
				RootBodyTM = RootBodyInst.GetUnrealWorldTM();
				CamStart.X = RootBodyTM.WPlane.X;
				CamStart.Y = RootBodyTM.WPlane.Y;
				CamStart.Z = RootBodyTM.WPlane.Z;
			}
		}
		CamStart += vect( 0,0,1 ) * BaseEyeHeight;

		CamDir = vector( out_CamRot ) * GetCollisionRadius() * CurrentCameraScale;
//		`log("Mesh"@Mesh.Bounds.Origin@" --- Base Eye Height "@BaseEyeHeight);

		if ( CamDir.Z > GetCollisionHeight() )
		{
			CamDir *= square( cos( out_CamRot.Pitch * 0.0000958738 ) ); // 0.0000958738 = 2*PI/65536
		}
		out_CamLoc = CamStart - CamDir;
		if ( Trace( HitLocation, HitNormal, out_CamLoc, CamStart, false, vect( 12,12,12 ) ) != None )
		{
			out_CamLoc = HitLocation;
		}
		return true;
	}

	simulated event OnAnimEnd( AnimNodeSequence SeqNode, float PlayedTime, float ExcessTime )
	{
		if ( Physics != PHYS_RigidBody && !bPlayingFeignDeathRecovery )
		{
			// blend out of feign death animation
			if ( FeignDeathBlend != None )
			{
				FeignDeathBlend.SetBlendTarget( 0.0, 0.5 );
			}
			GotoState( 'Auto' );
		}
	}

	simulated event BeginState( name PreviousStateName )
	{
		local UTPlayerController PC;
		local UTWeapon UTWeap;

		bCanPickupInventory = false;
		StopFiring();
		bNoWeaponFiring = true;

		UTWeap = UTWeapon( Weapon );
		if ( UTWeap != None )
		{
			UTWeap.PlayWeaponPutDown();
		}
		if( UTWeap != none && PC != none )
		{
			UTPlayerController( Controller ).EndZoom();
		}

		PC = UTPlayerController( Controller );
		if ( PC != None )
		{
            CameraScalePriorToFeignDeath = CameraScale;
            CurrentCameraScalePriorToFeignDeath = CurrentCameraScale;
            bBehindViewPriorToFeignDeath = PC.bBehindView;
			PC.SetBehindView( true );
			CurrentCameraScale = 1.5;
			CameraScale = 2.25;
		}

		DropFlag();
	}

	simulated function EndState( name NextStateName )
	{
		local UTPlayerController PC;
		local UTPawn P;

		if ( NextStateName != 'Dying' )
		{
			bNoWeaponFiring = default.bNoWeaponFiring;
			bCanPickupInventory = default.bCanPickupInventory;
			Global.SetMovementPhysics();
			PC = UTPlayerController( Controller );
			if ( PC != None )
			{
               PC.SetBehindView( bBehindViewPriorToFeignDeath );
			}

             CurrentCameraScale = CurrentCameraScalePriorToFeignDeath;
			CameraScale = CameraScalePriorToFeignDeath;
			bForcedFeignDeath = false;
			bPlayingFeignDeathRecovery = false;

			// jump away from other feigning death pawns to make sure we don't get stuck
			foreach TouchingActors( class'UTPawn', P )
			{
				if ( P.IsInState( 'FeigningDeath' ) )
				{
					JumpOffPawn();
				}
			}
		}
	}
}

// INFO (neoaez) 20080610: Thanks to the ACTIONCAM mutator for this fix 
// Correct aim to sync projectile trajectory with camera trace
simulated singular function Rotator GetBaseAimRotation()
{
    local vector    POVLoc;
    local rotator   POVRot;

    local vector TargetLocation;
    local vector HitLocation, HitNormal;

    // If we have a controller, by default we aim at the player's 'eyes' direction
    // that is by default Controller.Rotation for AI, and camera (crosshair) rotation for human players.
    if( Controller != None && !InFreeCam() )
    {
        Controller.GetPlayerViewPoint(POVLoc, POVRot);

        //INFO (neoaez) 20080610: changed Action Cam code in the following line from this:
        // TargetLocation = POVLoc + (vector(POVRot)*100000);
        //to remove arbitray scalar used in trace to that of the weapon equipped.  This follows the
        //example set out by the function GetWeaponAim in UTVehicle
        TargetLocation = POVLoc + (vector(POVRot)*Weapon.GetTraceRange());

        if(Trace(HitLocation, HitNormal, TargetLocation, POVLoc, false,,,TRACEFLAG_Bullet) == None)
            HitLocation = TargetLocation;

        POVRot = rotator(HitLocation - GetWeaponStartTraceLocation());

        return POVRot;
    }

    // If we have no controller, we simply use our rotation
    POVRot = Rotation;

    // If our Pitch is 0, then use RemoveViewPitch
    if( POVRot.Pitch == 0 )
    {
        POVRot.Pitch = RemoteViewPitch << 8;
    }

    return POVRot;
}

defaultproperties
{
}
