class MKWeap_SniperRifle extends UTWeap_SniperRifle; 

simulated function StartZoom(UTPlayerController PC)
{    
	ZoomCount++;
	if (ZoomCount == 1 && !IsTimerActive('Gotozoom') && IsActiveWeapon() && HasAmmo(0))
	{
        if(!Instigator.IsFirstPerson())
        {
            PC.SetBehindView(false);
        }
		bDisplayCrosshair = false;
		PlayWeaponAnimation('WeaponZoomIn',0.2);
		PlayArmAnimation('WeaponZoomIn',0.2);
		bAbortZoom = false;
		SetTimer(0.2, false, 'Gotozoom');
	}
}

simulated function LeaveZoom()
{
	local UTPlayerController PC;

	bAbortZoom = false;
	PC = UTPlayerController(Instigator.Controller);
	if (PC != none)
	{
		PC.EndZoom();
	}
	ZoomCount = 0;
	if(Instigator.IsFirstPerson())
	{
        LogInternal("MKLOG -> LeaveZoom: Instigator is FIRST PERSON");
		ChangeVisibility(true);
	}

	PlayWeaponAnimation('WeaponZoomOut',0.3);
	PlayArmAnimation('WeaponZoomOut',0.3);
	SetTimer(0.3,false,'RestartCrosshair');
    SetTimer(0.0001,false,'RestartBehindView');
}

simulated function RestartBehindView()
{
    
	local UTPlayerController PC;
    
    LogInternal ("MKLOG -> RestartBehindView: CALLED");
    PC = UTPlayerController(Instigator.Controller);
    if (PC != None)
    {
        if(Instigator.IsFirstPerson())
        {
            LogInternal ("MKLOG -> RestartBehindView: Setting BEHINDVIEW to TRUE");
            PC.SetBehindView(true);
        }
    }
}

simulated function ChangeVisibility(bool bIsVisible)
{
    LogInternal ("MKLOG -> ChangeVisibility: CALLED");
	super.Changevisibility(bIsvisible);
	if(bIsVisible)
	{
        LogInternal ("MKLOG -> ChangeVisibility: bIsVisible is TRUE");
		PlayArmAnimation('WeaponZoomOut',0.00001); // to cover zooms ended while in 3p
	}
	if(!Instigator.IsFirstPerson()) // to be consistent with not allowing zoom from 3p
	{
		//LeaveZoom();
	}

}


defaultproperties
{
    //ItemName="Sniper Rifle (TPS)"
}
