class MK3rdPersonMutator extends UTMutator config(MK3rdPersonMutator);

function InitMutator(string options, out string ErrorMessage)
{
    //INFO (neoaez): check for valid values

    //DEBUG
    //LogInternal("MKLOG -> InitMutator: CALLED");
    //DEBUG
    SaveConfig();
    Super.InitMutator(options, ErrorMessage);
}

function ModifyPlayer(Pawn Other)
{
    local UTPawn P;
    local UTPlayerController C;
    P = UTPawn(Other);
    if(P != None)
    {
        C = UTPlayerController(P.Controller);
        C.SetBehindView(true);
    }
    Super.ModifyPlayer(Other);
}

function PostBeginPlay()
{
	local UTGame Game;
	local int i;

    //DEBUG
    //LogInteral ("MKLOG -> PostBeginPlay: CALLED");
    //DEBUG

    Super.PostBeginPlay();

	// replace default weapons
	Game = UTGame(WorldInfo.Game);
	if (Game != None)
	{
		for (i = 0; i < Game.DefaultInventory.length; i++)
		{
			if (Game.DefaultInventory[i].IsA('UTWeap_SniperRifle'))
			{
					Game.DefaultInventory[i] = class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class'));
			}
            else
            {
                //DEBUG
                //LogInternal("MKLOG -> PostBeginPlay: Cycling through Game.DefaultInventory:"@Game.DefaultInventory[i]);
                //DEBUG
            }
		}
	}
}

function bool CheckReplacement(Actor Other)
{
	local UTWeaponPickupFactory WeaponPickup;
	local UTWeaponLocker Locker;
    local int i;

    //DEBUG
    //LogInternal("MKLOG -> CheckReplacement: CALLED");
    //DEBUG

    WeaponPickup = UTWeaponPickupFactory(Other);
	if (WeaponPickup != None)
	{
        //DEBUG
        //LogInternal("MKLOG -> CheckReplacement: WeaponPickup:"@WeaponPickup);
        //DEBUG

        if (WeaponPickup.WeaponPickupClass == class'UTWeap_SniperRifle')
		{
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: UTWeap_SniperRifle found and is being replaced.");
            //DEBUG

			WeaponPickup.WeaponPickupClass = class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class'));
			WeaponPickup.InitializePickup();
		}
        else
        {
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: WeaponPickup.WeaponPickupClass:"@WeaponPickup.WeaponPickupClass);
            //DEBUG
        }
	}
	else
	{
		Locker = UTWeaponLocker(Other);
		if (Locker != None)
		{
			for (i = 0; i < Locker.Weapons.length; i++)
			{
                //DEBUG
                //LogInternal("MKLOG -> CheckReplacement: Locker.Weapons[i].WeaponClass:"@Locker.Weapons[i].WeaponClass);
                //DEBUG

                if (Locker.Weapons[i].WeaponClass.IsA('UTWeap_SniperRifle'))
				{
                   Locker.ReplaceWeapon(i, class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class')));
				}
			}
		}
        else
        {
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: Locker == NONE");
            //DEBUG
        }
	}
	return true;
}

defaultproperties
{
    Name="MK3rdPersonMutator"
}
