class MKPawn extends UTPawn;

var float CameraScalePriorToFeignDeath, CurrentCameraScalePriorToFeignDeath;
var bool  bBehindViewPriorToFeignDeath;
/*
//DEBUG (neoaez @ 20071127): removing this as I test out changing the mutator functions to simulated
var repnotify float CameraScale, CurrentCameraScale;

replication
{
	// replicated properties
	if ( bNetDirty )
        CameraScale, CurrentCameraScale;
}
*/

reliable client function ClientSetCameraScale( float scale )
{
    CameraScale = scale;
    CurrentCameraScale = scale;
}

state FeigningDeath
{
	ignores ServerHoverboard, SwitchWeapon, QuickPick, FaceRotation, ForceRagdoll, AdjustCameraScale, SetMovementPhysics;

	exec simulated function FeignDeath()
	{
		if (bFeigningDeath)
		{
			Global.FeignDeath();
		}
	}

	reliable server function ServerFeignDeath()
	{
		if (Role == ROLE_Authority && !WorldInfo.GRI.bMatchIsOver && !IsTimerActive('FeignDeathDelayTimer') && bFeigningDeath)
		{
			bFeigningDeath = false;
			PlayFeignDeath();
		}
	}

	event bool EncroachingOn(Actor Other)
	{
		// don't abort moves in ragdoll
		return false;
	}

	simulated function bool CanThrowWeapon()
	{
		return false;
	}

	simulated function Tick(float DeltaTime)
	{
		local rotator NewRotation;

		if (bPlayingFeignDeathRecovery && PlayerController(Controller) != None)
		{
			// interpolate Controller yaw to our yaw so that we don't get our rotation snapped around when we get out of feign death
			NewRotation = Controller.Rotation;
			NewRotation.Yaw = RInterpTo(NewRotation, Rotation, DeltaTime, 2.0).Yaw;
			Controller.SetRotation(NewRotation);

			if ( WorldInfo.TimeSeconds - FeignDeathRecoveryStartTime > 0.8 )
			{
				CameraScale = 1.0;
			}
		}
	}

	simulated function bool CalcThirdPersonCam( float fDeltaTime, out vector out_CamLoc, out rotator out_CamRot, out float out_FOV )
	{
		local vector CamStart, HitLocation, HitNormal, CamDir;
		local RB_BodyInstance RootBodyInst;
		local matrix RootBodyTM;

		if (CurrentCameraScale < CameraScale)
		{
			CurrentCameraScale = FMin(CameraScale, CurrentCameraScale + 5 * FMax(CameraScale - CurrentCameraScale, 0.3)*fDeltaTime);
		}
		else if (CurrentCameraScale > CameraScale)
		{
			CurrentCameraScale = FMax(CameraScale, CurrentCameraScale - 5 * FMax(CameraScale - CurrentCameraScale, 0.3)*fDeltaTime);
		}

//		CamStart = Mesh.Bounds.Origin + vect(0,0,1) * BaseEyeHeight; (Replaced with below due to Bounds being updated 2x per frame which can result in jitter-cam
		CamStart = Mesh.GetPosition();
		if(Mesh.PhysicsAssetInstance != None)
		{
			RootBodyInst = Mesh.PhysicsAssetInstance.Bodies[Mesh.PhysicsAssetInstance.RootBodyIndex];
			if(RootBodyInst.IsValidBodyInstance())
			{
				RootBodyTM = RootBodyInst.GetUnrealWorldTM();
				CamStart.X = RootBodyTM.WPlane.X;
				CamStart.Y = RootBodyTM.WPlane.Y;
				CamStart.Z = RootBodyTM.WPlane.Z;
			}
		}
		CamStart += vect(0,0,1) * BaseEyeHeight;

		CamDir = vector(out_CamRot) * GetCollisionRadius() * CurrentCameraScale;
//		`log("Mesh"@Mesh.Bounds.Origin@" --- Base Eye Height "@BaseEyeHeight);

		if (CamDir.Z > GetCollisionHeight())
		{
			CamDir *= square(cos(out_CamRot.Pitch * 0.0000958738)); // 0.0000958738 = 2*PI/65536
		}
		out_CamLoc = CamStart - CamDir;
		if (Trace(HitLocation, HitNormal, out_CamLoc, CamStart, false, vect(12,12,12)) != None)
		{
			out_CamLoc = HitLocation;
		}
		return true;
	}

	simulated event OnAnimEnd(AnimNodeSequence SeqNode, float PlayedTime, float ExcessTime)
	{
		if (Physics != PHYS_RigidBody && !bPlayingFeignDeathRecovery)
		{
			// blend out of feign death animation
			if (FeignDeathBlend != None)
			{
				FeignDeathBlend.SetBlendTarget(0.0, 0.5);
			}
			GotoState('Auto');
		}
	}

	simulated event BeginState(name PreviousStateName)
	{
		local UTPlayerController PC;
		local UTWeapon UTWeap;

		bCanPickupInventory = false;
		StopFiring();
		bNoWeaponFiring = true;

		UTWeap = UTWeapon(Weapon);
		if (UTWeap != None)
		{
			UTWeap.PlayWeaponPutDown();
		}
		if(UTWeap != none && PC != none)
		{
			UTPlayerController(Controller).EndZoom();
		}

		PC = UTPlayerController(Controller);
		if (PC != None)
		{
            CameraScalePriorToFeignDeath = CameraScale;
            CurrentCameraScalePriorToFeignDeath = CurrentCameraScale;
            bBehindViewPriorToFeignDeath = PC.bBehindView;
			PC.SetBehindView(true);
			CurrentCameraScale = 1.5;
			CameraScale = 2.25;
		}

		DropFlag();
	}

	simulated function EndState(name NextStateName)
	{
		local UTPlayerController PC;
		local UTPawn P;

		if (NextStateName != 'Dying')
		{
			bNoWeaponFiring = default.bNoWeaponFiring;
			bCanPickupInventory = default.bCanPickupInventory;
			Global.SetMovementPhysics();
			PC = UTPlayerController(Controller);
			if (PC != None)
			{
				//PC.SetBehindView(PC.default.bBehindView);
                PC.SetBehindView(bBehindViewPriorToFeignDeath);
			}

			//CurrentCameraScale = default.CurrentCameraScale;
			//CameraScale = default.CameraScale;
            CurrentCameraScale = CurrentCameraScalePriorToFeignDeath;
			CameraScale = CameraScalePriorToFeignDeath;
			bForcedFeignDeath = false;
			bPlayingFeignDeathRecovery = false;

			// jump away from other feigning death pawns to make sure we don't get stuck
			foreach TouchingActors(class'UTPawn', P)
			{
				if (P.IsInState('FeigningDeath'))
				{
					JumpOffPawn();
				}
			}
		}
	}
}

defaultproperties
{
}
