class MK3rdPersonMutator extends UTMutator config(MK3rdPersonMutator);

var config string CfgValidate;
var config float CfgCameraScale;

simulated function InitMutator(string options, out string ErrorMessage)
{
    //DEBUG
    //LogInternal("MKLOG -> InitMutator: CALLED");
    //DEBUG

    //INFO (neoaez): Validate the INI and recreate if missing
    if (CfgValidate != "VALID")
    {
        LogInternal("MKLOG -> InitMutator: Config file was not valid.  Recreating.");
        CfgValidate = "VALID";
        CfgCameraScale = 9.0;
    }
    //INFO (neoaez): check for valid values
    if (CfgCameraScale > 40.0) { CfgCameraScale = 40.0; }
    if (CfgCameraScale < 1.0) { CfgCameraScale = 1.0; }

    SaveConfig();

    //INFO (neoaez): continue the mutator chain
    Super.InitMutator(options, ErrorMessage);
}

simulated function ModifyPlayer(Pawn Other)
{
    local UTPawn P;
    local MKPawn MP;
    local UTPlayerController C;

    P = UTPawn(Other);
    if(P != None)
    {

        MP = MKPawn(P);
        if (MP != None)
        {
            MP.ClientSetCameraScale(CfgCameraScale);
        }
        C = UTPlayerController(P.Controller);
        if (C != None)
        {
            //DEBUG
            LogInternal("MKLOG -> ModifyPlayer: CfgCameraScale:"@CfgCameraScale);
            //DEBUG
            C.SetCameraMode( 'ThirdPerson' );
        }
    }
    Super.ModifyPlayer(Other);
}

simulated function PostBeginPlay()
{
	local UTGame Game;
	local int i;

    //DEBUG
    //LogInteral ("MKLOG -> PostBeginPlay: CALLED");
    //DEBUG

    Super.PostBeginPlay();

	// replace default weapons
	Game = UTGame(WorldInfo.Game);
	if (Game != None)
	{
        //INFO (neoaez): set the default pawn class to our own
        Game.DefaultPawnClass = class'MK3rdPersonMutator.MKPawn';
		for (i = 0; i < Game.DefaultInventory.length; i++)
		{
			if (Game.DefaultInventory[i].IsA('UTWeap_SniperRifle'))
			{
					Game.DefaultInventory[i] = class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class'));
			}
            else
            {
                //DEBUG
                //LogInternal("MKLOG -> PostBeginPlay: Cycling through Game.DefaultInventory:"@Game.DefaultInventory[i]);
                //DEBUG
            }
		}
	}
}

simulated function bool CheckReplacement(Actor Other)
{
	local UTWeaponPickupFactory WeaponPickup;
	local UTWeaponLocker Locker;
    local int i;
    //local UTPawn P;

    //DEBUG
    //LogInternal("MKLOG -> CheckReplacement: CALLED");
    //DEBUG

    //INFO (neoaez): Replace UTPawn with our MKPawn so the thirdperson camera distance can be modified
    //INFO (neoaez): This does not work!
    //P = UTPawn(Other);
    //if (P != None)
    //{
        //DEBUG
        //LogInternal("MKLOG -> CheckReplacement: Other is a UTPawn.");
        //DEBUG
        //P.CurrentCameraScale = CfgCameraScale;
        //P.CameraScale = CfgCameraScale;
    //}

    WeaponPickup = UTWeaponPickupFactory(Other);
	if (WeaponPickup != None)
	{
        //DEBUG
        //LogInternal("MKLOG -> CheckReplacement: WeaponPickup:"@WeaponPickup);
        //DEBUG

        if (WeaponPickup.WeaponPickupClass == class'UTWeap_SniperRifle')
		{
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: UTWeap_SniperRifle found and is being replaced.");
            //DEBUG

			WeaponPickup.WeaponPickupClass = class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class'));
			WeaponPickup.InitializePickup();
		}
        else
        {
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: WeaponPickup.WeaponPickupClass:"@WeaponPickup.WeaponPickupClass);
            //DEBUG
        }
	}
	else
	{
		Locker = UTWeaponLocker(Other);
		if (Locker != None)
		{
			for (i = 0; i < Locker.Weapons.length; i++)
			{
                //DEBUG
                //LogInternal("MKLOG -> CheckReplacement: Locker.Weapons[i].WeaponClass:"@Locker.Weapons[i].WeaponClass);
                //DEBUG

                if (Locker.Weapons[i].WeaponClass.IsA('UTWeap_SniperRifle'))
				{
                   Locker.ReplaceWeapon(i, class<UTWeapon>(DynamicLoadObject("MK3rdPersonMutator.MKWeap_SniperRifle", class'Class')));
				}
			}
		}
        else
        {
            //DEBUG
            //LogInternal("MKLOG -> CheckReplacement: Locker == NONE");
            //DEBUG
        }
	}
	return true;
}

defaultproperties
{
    Name="MK3rdPersonMutator"
    bAlwaysRelevant=true
    RemoteRole=ROLE_AutonomousProxy
}
