class UTDmgType_Freeze extends UTDamageType;

static function string DeathMessage(PlayerReplicationInfo Killer, PlayerReplicationInfo Victim)
{
	return Victim.PlayerName@"was frozen to death by"@Killer.PlayerName$"'s Freeze Ray.";
}

static function string SuicideMessage(PlayerReplicationInfo Victim)
{
	if ( (Victim != None) && Victim.bIsFemale )
		return Victim.PlayerName@"managed to kill herself with her own Freeze Ray.";
	else
		return Victim.PlayerName@"managed to kill himself with his own Freeze Ray.";
}

static function SpawnHitEffect(Pawn P, float Damage, vector Momentum, name BoneName, vector HitLocation)
{
	super(UTDamageType).SpawnHitEffect(P,Damage,Momentum,BoneName,HitLocation);
}

defaultproperties
{
	KillStatsName=KILLS_FREEZE
	DeathStatsName=DEATHS_FREEZE
	SuicideStatsName=SUICIDES_FREEZE
	DamageWeaponClass=class'UTWeap_FreezeRay'
	DamageWeaponFireMode=2
    bAlwaysGibs=true
    AlwaysGibDamageThreshold=15
	GibPerterbation=1
	GibThreshold=0
	bCausesBlood=false
	bArmorStops=false
	bOverrideHitEffectColor=true
	HitEffectColor=(R=-1.0,G=-1.0,B=2.0)
	DamageBodyMatColor=(R=0,B=10)
	bComplainFriendlyFire=false
	bIgnoreDriverDamageMult=true
	GibModifier=5
}